/*
 * Decompiled with CFR 0.152.
 */
package com.yc.pagerlib.pager;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.yc.pagerlib.inter.OnPagerListener;
import java.lang.reflect.Field;

public class LayoutViewPager
extends ViewPager
implements ViewPager.OnPageChangeListener {
    private boolean scrollable = true;
    private long mRecentTouchTime;
    private OnPagerListener mOnViewPagerListener;
    private int mDrift;
    private int position;
    private View.OnAttachStateChangeListener listener = new View.OnAttachStateChangeListener(){

        public void onViewAttachedToWindow(View v) {
            if (LayoutViewPager.this.mOnViewPagerListener != null && LayoutViewPager.this.getChildCount() == 1) {
                LayoutViewPager.this.mOnViewPagerListener.onInitComplete();
            }
        }

        public void onViewDetachedFromWindow(View v) {
            if (LayoutViewPager.this.mDrift >= 0) {
                if (LayoutViewPager.this.mOnViewPagerListener != null) {
                    LayoutViewPager.this.mOnViewPagerListener.onPageRelease(true, LayoutViewPager.this.position);
                }
            } else if (LayoutViewPager.this.mOnViewPagerListener != null) {
                LayoutViewPager.this.mOnViewPagerListener.onPageRelease(false, LayoutViewPager.this.position);
            }
        }
    };

    public LayoutViewPager(Context context) {
        super(context);
        this.init();
    }

    public LayoutViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.setPageTransformer(true, new DefaultTransformer());
        this.setOverScrollMode(2);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.scrollable) {
            if (this.getCurrentItem() == 0 && this.getChildCount() == 0) {
                return false;
            }
            return super.onTouchEvent(ev);
        }
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.mRecentTouchTime = System.currentTimeMillis();
        if (this.scrollable) {
            if (this.getCurrentItem() == 0 && this.getChildCount() == 0) {
                return false;
            }
            boolean intercept = super.onInterceptTouchEvent(this.swapEvent(ev));
            this.swapEvent(ev);
            return intercept;
        }
        return false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.addOnAttachStateChangeListener(this.listener);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeOnAttachStateChangeListener(this.listener);
    }

    private MotionEvent swapEvent(MotionEvent event) {
        float width = this.getWidth();
        float height = this.getHeight();
        float swappedX = event.getY() / height * width;
        float swappedY = event.getX() / width * height;
        event.setLocation(swappedX, swappedY);
        return event;
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        this.mDrift = t - oldt;
    }

    public void setOnViewPagerListener(OnPagerListener listener) {
        this.mOnViewPagerListener = listener;
    }

    public void onPageScrolled(int i, float v, int i1) {
        super.onPageScrolled(i, v, i1);
    }

    public void onPageSelected(int i) {
        this.position = i;
    }

    public void onPageScrollStateChanged(int i) {
    }

    @TargetApi(value=19)
    public void setAnimationDuration(final int during) {
        try {
            Field mField = ViewPager.class.getDeclaredField("mScroller");
            mField.setAccessible(true);
            Interpolator interpolator = new Interpolator(){

                public float getInterpolation(float t) {
                    return (t -= 1.0f) * t * t * t * t + 1.0f;
                }
            };
            Scroller mScroller = new Scroller(this.getContext(), interpolator){
                final int time = 2000;
                {
                    super(x0, x1);
                    this.time = 2000;
                }

                public void startScroll(int x, int y, int dx, int dy, int duration) {
                    duration = System.currentTimeMillis() - LayoutViewPager.this.mRecentTouchTime > 2000L ? during : (duration /= 2);
                    super.startScroll(x, y, dx, dy, duration);
                }

                public void startScroll(int x, int y, int dx, int dy) {
                    super.startScroll(x, y, dx, dy, during);
                }
            };
            mField.set((Object)this, mScroller);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
    }

    public class DefaultTransformer
    implements ViewPager.PageTransformer {
        public void transformPage(@NonNull View view, float position) {
            float alpha = 0.0f;
            if (0.0f <= position && position <= 1.0f) {
                alpha = 1.0f - position;
            } else if (-1.0f < position && position < 0.0f) {
                alpha = position + 1.0f;
            }
            view.setAlpha(alpha);
            float transX = (float)view.getWidth() * -position;
            view.setTranslationX(transX);
            float transY = position * (float)view.getHeight();
            view.setTranslationY(transY);
        }
    }
}

