/*
 * Decompiled with CFR 0.152.
 */
package com.yc.pagerlib.pager;

import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import com.yc.pagerlib.inter.OnPagerListener;
import java.util.List;

public abstract class AbsPagerAdapter<T>
extends PagerAdapter {
    private List<T> mDataList;
    private OnPagerListener mOnViewPagerListener;
    private int startPosition;

    public AbsPagerAdapter(List<T> dataList) {
        this.mDataList = dataList;
    }

    public void setOnViewPagerListener(OnPagerListener listener) {
        this.mOnViewPagerListener = listener;
        listener.onInitComplete();
    }

    public int getCount() {
        if (this.mDataList == null) {
            return 0;
        }
        return this.mDataList.size();
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        this.startPosition = position;
        View view = this.getView(container, position);
        if (this.mOnViewPagerListener != null) {
            this.mOnViewPagerListener.onPageSelected(position, true);
        }
        container.addView(view);
        return view;
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        if (this.startPosition > position) {
            if (this.mOnViewPagerListener != null) {
                this.mOnViewPagerListener.onPageRelease(true, position);
            }
        } else if (this.mOnViewPagerListener != null) {
            this.mOnViewPagerListener.onPageRelease(false, position);
        }
        container.removeView((View)object);
    }

    public abstract View getView(ViewGroup var1, int var2);
}

