/*
 * Decompiled with CFR 0.152.
 */
package com.yashdev.libspin;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.yashdev.libspin.R;
import com.yashdev.libspin.model.SpinItem;
import com.yashdev.libspin.utils.Utils;
import com.yashdev.libspin.views.Spin;
import java.util.List;
import java.util.Random;

public class SpinWheel
extends RelativeLayout
implements Spin.PieRotateListener {
    private int mBackgroundColor;
    private int mTextColor;
    private int mTopTextSize;
    private int mSecondaryTextSize;
    private int mBorderColor;
    private int mTopTextPadding;
    private int mEdgeWidth;
    private Drawable mCenterImage;
    private Drawable mCursorImage;
    private Spin spin;
    private ImageView ivCursorView;
    private SpinWheelRoundItemSelectedListener spinWheelRoundItemSelectedListener;

    @Override
    public void rotateDone(int index) {
        if (this.spinWheelRoundItemSelectedListener != null) {
            this.spinWheelRoundItemSelectedListener.SpinWheelRoundItemSelected(index);
        }
    }

    public void setSpinWheelRoundItemSelectedListener(SpinWheelRoundItemSelectedListener listener) {
        this.spinWheelRoundItemSelectedListener = listener;
    }

    public SpinWheel(Context context) {
        super(context);
        this.init(context, null);
    }

    public SpinWheel(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context ctx, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = ctx.obtainStyledAttributes(attrs, R.styleable.SpinWheelView);
            this.mBackgroundColor = typedArray.getColor(R.styleable.SpinWheelView_spnwBackgroundColor, -3407872);
            this.mTopTextSize = typedArray.getDimensionPixelSize(R.styleable.SpinWheelView_spnwTopTextSize, (int)Utils.convertDpToPixel(15.0f, this.getContext()));
            this.mSecondaryTextSize = typedArray.getDimensionPixelSize(R.styleable.SpinWheelView_spnwSecondaryTextSize, (int)Utils.convertDpToPixel(20.0f, this.getContext()));
            this.mTextColor = typedArray.getColor(R.styleable.SpinWheelView_spnwTopTextColor, 0);
            this.mTopTextPadding = typedArray.getDimensionPixelSize(R.styleable.SpinWheelView_spnwTopTextPadding, (int)Utils.convertDpToPixel(25.0f, this.getContext())) + (int)Utils.convertDpToPixel(10.0f, this.getContext());
            this.mCursorImage = typedArray.getDrawable(R.styleable.SpinWheelView_spnwCursor);
            this.mCenterImage = typedArray.getDrawable(R.styleable.SpinWheelView_spnwCenterImage);
            this.mEdgeWidth = typedArray.getInt(R.styleable.SpinWheelView_spnwEdgeWidth, 10);
            this.mBorderColor = typedArray.getColor(R.styleable.SpinWheelView_spnwEdgeColor, 0);
            typedArray.recycle();
        }
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        FrameLayout frameLayout = (FrameLayout)inflater.inflate(R.layout.layout_spinwheel, (ViewGroup)this, false);
        this.spin = (Spin)frameLayout.findViewById(R.id.spinView);
        this.ivCursorView = (ImageView)frameLayout.findViewById(R.id.cursorView);
        this.spin.setPieRotateListener(this);
        this.spin.setPieBackgroundColor(this.mBackgroundColor);
        this.spin.setTopTextPadding(this.mTopTextPadding);
        this.spin.setTopTextSize(this.mTopTextSize);
        this.spin.setSecondaryTextSizeSize(this.mSecondaryTextSize);
        this.spin.setPieCenterImage(this.mCenterImage);
        this.spin.setBorderColor(this.mBorderColor);
        this.spin.setBorderWidth(this.mEdgeWidth);
        if (this.mTextColor != 0) {
            this.spin.setPieTextColor(this.mTextColor);
        }
        this.ivCursorView.setImageDrawable(this.mCursorImage);
        this.addView((View)frameLayout);
    }

    public boolean isTouchEnabled() {
        return this.spin.isTouchEnabled();
    }

    public void setTouchEnabled(boolean touchEnabled) {
        this.spin.setTouchEnabled(touchEnabled);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!this.isPielView(this.getChildAt(i))) continue;
            return super.dispatchTouchEvent(ev);
        }
        return false;
    }

    private boolean isPielView(View view) {
        if (view instanceof ViewGroup) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                if (!this.isPielView(((ViewGroup)view).getChildAt(i))) continue;
                return true;
            }
        }
        return view instanceof Spin;
    }

    public void setSpinWheelBackgrouldColor(int color) {
        this.spin.setPieBackgroundColor(color);
    }

    public void setSpinWheelCursorImage(int drawable) {
        this.ivCursorView.setBackgroundResource(drawable);
    }

    public void setSpinWheelCenterImage(Drawable drawable) {
        this.spin.setPieCenterImage(drawable);
    }

    public void setBorderColor(int color) {
        this.spin.setBorderColor(color);
    }

    public void setSpinWheelTextColor(int color) {
        this.spin.setPieTextColor(color);
    }

    public void setData(List<SpinItem> data) {
        this.spin.setData(data);
    }

    public void setRound(int numberOfRound) {
        this.spin.setRound(numberOfRound);
    }

    public void setPredeterminedNumber(int fixedNumber) {
        this.spin.setPredeterminedNumber(fixedNumber);
    }

    public void startSpinWheelWithTargetIndex(int index) {
        this.spin.rotateTo(index);
    }

    public void startSpinWheelWithRandomTarget() {
        Random r = new Random();
        this.spin.rotateTo(r.nextInt(this.spin.getSpinItemListSize() - 1));
    }

    public static interface SpinWheelRoundItemSelectedListener {
        public void SpinWheelRoundItemSelected(int var1);
    }
}

