/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.util;

import android.text.TextUtils;
import java.util.Collection;
import java.util.Map;

public abstract class Assert {
    public static void state(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isNull(Object object, String message) {
        if (object != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void hasLength(String text, String message) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void hasText(String text, String message) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void doesNotContain(String textToSearch, String substring, String message) {
        if (!TextUtils.isEmpty((CharSequence)textToSearch) && !TextUtils.isEmpty((CharSequence)substring) && textToSearch.contains(substring)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Object[] array, String message) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void noNullElements(Object[] array, String message) {
        if (array != null) {
            for (Object element : array) {
                if (element != null) continue;
                throw new IllegalArgumentException(message);
            }
        }
    }

    public static void notEmpty(Collection<?> collection, String message) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Map<?, ?> map, String message) {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj, String message) {
        Assert.notNull(type, "Type to check against must not be null");
        if (!type.isInstance(obj)) {
            Assert.instanceCheckFailed(type, obj, message);
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj) {
        Assert.isInstanceOf(type, obj, "");
    }

    public static void isAssignable(Class<?> superType, Class<?> subType, String message) {
        Assert.notNull(superType, "Super type to check against must not be null");
        if (subType == null || !superType.isAssignableFrom(subType)) {
            Assert.assignableCheckFailed(superType, subType, message);
        }
    }

    public static void isAssignable(Class<?> superType, Class<?> subType) {
        Assert.isAssignable(superType, subType, "");
    }

    private static void instanceCheckFailed(Class<?> type, Object obj, String msg) {
        String className = obj != null ? obj.getClass().getName() : "null";
        String result = "";
        boolean defaultMessage = true;
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            if (Assert.endsWithSeparator(msg)) {
                result = msg + " ";
            } else {
                result = Assert.messageWithTypeName(msg, className);
                defaultMessage = false;
            }
        }
        if (defaultMessage) {
            result = result + "Object of class [" + className + "] must be an instance of " + type;
        }
        throw new IllegalArgumentException(result);
    }

    private static void assignableCheckFailed(Class<?> superType, Class<?> subType, String msg) {
        String result = "";
        boolean defaultMessage = true;
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            if (Assert.endsWithSeparator(msg)) {
                result = msg + " ";
            } else {
                result = Assert.messageWithTypeName(msg, subType);
                defaultMessage = false;
            }
        }
        if (defaultMessage) {
            result = result + subType + " is not assignable to " + superType;
        }
        throw new IllegalArgumentException(result);
    }

    private static boolean endsWithSeparator(String msg) {
        return msg.endsWith(":") || msg.endsWith(";") || msg.endsWith(",") || msg.endsWith(".");
    }

    private static String messageWithTypeName(String msg, Object typeName) {
        return msg + (msg.endsWith(" ") ? "" : ": ") + typeName;
    }
}

