/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.http.multipart;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.yanzhenjie.andserver.error.MaxUploadSizeExceededException;
import com.yanzhenjie.andserver.error.MultipartException;
import com.yanzhenjie.andserver.http.HttpRequest;
import com.yanzhenjie.andserver.http.RequestBody;
import com.yanzhenjie.andserver.http.multipart.BodyContext;
import com.yanzhenjie.andserver.http.multipart.MultipartFile;
import com.yanzhenjie.andserver.http.multipart.MultipartRequest;
import com.yanzhenjie.andserver.http.multipart.MultipartResolver;
import com.yanzhenjie.andserver.http.multipart.StandardMultipartFile;
import com.yanzhenjie.andserver.http.multipart.StandardMultipartRequest;
import com.yanzhenjie.andserver.util.Assert;
import com.yanzhenjie.andserver.util.LinkedMultiValueMap;
import com.yanzhenjie.andserver.util.MediaType;
import com.yanzhenjie.andserver.util.MultiValueMap;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.Charsets;

public class StandardMultipartResolver
implements MultipartResolver {
    private DiskFileItemFactory mFileItemFactory = new DiskFileItemFactory();
    private FileUpload mFileUpload = new FileUpload((FileItemFactory)this.mFileItemFactory);

    @Override
    public void setAllFileMaxSize(long allFileMaxSize) {
        this.mFileUpload.setSizeMax(allFileMaxSize);
    }

    @Override
    public void setFileMaxSize(long fileMaxSize) {
        this.mFileUpload.setFileSizeMax(fileMaxSize);
    }

    @Override
    public void setMaxInMemorySize(int maxInMemorySize) {
        this.mFileItemFactory.setSizeThreshold(maxInMemorySize);
    }

    @Override
    public void setUploadTempDir(File uploadTempDir) {
        if (!uploadTempDir.exists() && !uploadTempDir.mkdirs()) {
            String message = "Given uploadTempDir [" + uploadTempDir + "] could not be created.";
            throw new IllegalArgumentException(message);
        }
        this.mFileItemFactory.setRepository(uploadTempDir);
    }

    @Override
    public boolean isMultipart(HttpRequest request) {
        if (!request.getMethod().allowBody()) {
            return false;
        }
        RequestBody body = request.getBody();
        return body != null && FileUploadBase.isMultipartContent((RequestContext)new BodyContext(body));
    }

    @Override
    public MultipartRequest resolveMultipart(HttpRequest request) throws MultipartException {
        if (request instanceof MultipartRequest) {
            return (MultipartRequest)request;
        }
        MultipartParsingResult result = this.parseRequest(request);
        return new StandardMultipartRequest(request, result.getMultipartFiles(), result.getMultipartParameters(), result.getMultipartContentTypes());
    }

    @Override
    public void cleanupMultipart(MultipartRequest request) {
        if (request != null) {
            try {
                MultiValueMap<String, MultipartFile> multipartFiles = request.getMultiFileMap();
                for (List files : multipartFiles.values()) {
                    for (MultipartFile file : files) {
                        if (!(file instanceof StandardMultipartFile)) continue;
                        StandardMultipartFile cmf = (StandardMultipartFile)file;
                        cmf.getFileItem().delete();
                    }
                }
            }
            catch (Throwable ex) {
                Log.w((String)"AndServer", (String)"Failed to perform multipart cleanup for servlet request.");
            }
        }
    }

    private MultipartParsingResult parseRequest(HttpRequest request) throws MultipartException {
        String encoding = this.determineEncoding(request);
        FileUpload fileUpload = this.prepareFileUpload(encoding);
        try {
            RequestBody body = request.getBody();
            Assert.notNull(body, "The body cannot be null.");
            List fileItems = fileUpload.parseRequest((RequestContext)new BodyContext(body));
            return this.parseFileItems(fileItems, encoding);
        }
        catch (FileUploadBase.SizeLimitExceededException ex) {
            throw new MaxUploadSizeExceededException(fileUpload.getSizeMax(), (Throwable)ex);
        }
        catch (FileUploadBase.FileSizeLimitExceededException ex) {
            throw new MaxUploadSizeExceededException(fileUpload.getFileSizeMax(), (Throwable)ex);
        }
        catch (FileUploadException ex) {
            throw new MultipartException("Failed to parse multipart servlet request.", (Throwable)ex);
        }
    }

    @NonNull
    private String determineEncoding(HttpRequest request) {
        MediaType mimeType = request.getContentType();
        if (mimeType == null) {
            return Charsets.toCharset((String)"utf-8").name();
        }
        Charset charset = mimeType.getCharset();
        return charset == null ? Charsets.toCharset((String)"utf-8").name() : charset.name();
    }

    private FileUpload prepareFileUpload(@NonNull String encoding) {
        FileUpload actualFileUpload = this.mFileUpload;
        if (!encoding.equalsIgnoreCase(this.mFileUpload.getHeaderEncoding())) {
            actualFileUpload = new FileUpload((FileItemFactory)this.mFileItemFactory);
            actualFileUpload.setSizeMax(this.mFileUpload.getSizeMax());
            actualFileUpload.setFileSizeMax(this.mFileUpload.getFileSizeMax());
            actualFileUpload.setHeaderEncoding(encoding);
        }
        return actualFileUpload;
    }

    protected MultipartParsingResult parseFileItems(List<FileItem> fileItems, String encoding) {
        LinkedMultiValueMap<String, MultipartFile> multipartFiles = new LinkedMultiValueMap<String, MultipartFile>();
        LinkedMultiValueMap<String, String> multipartParameters = new LinkedMultiValueMap<String, String>();
        HashMap<String, String> multipartContentTypes = new HashMap<String, String>();
        for (FileItem fileItem : fileItems) {
            if (fileItem.isFormField()) {
                LinkedList<String> curParam;
                String value;
                String partEncoding = this.determineEncoding(fileItem.getContentType(), encoding);
                if (partEncoding != null) {
                    try {
                        value = fileItem.getString(partEncoding);
                    }
                    catch (UnsupportedEncodingException ex) {
                        value = fileItem.getString();
                    }
                } else {
                    value = fileItem.getString();
                }
                if ((curParam = (LinkedList<String>)multipartParameters.get(fileItem.getFieldName())) == null) {
                    curParam = new LinkedList<String>();
                    curParam.add(value);
                    multipartParameters.put(fileItem.getFieldName(), (String)((Object)curParam));
                } else {
                    curParam.add(value);
                }
                multipartContentTypes.put(fileItem.getFieldName(), fileItem.getContentType());
                continue;
            }
            StandardMultipartFile file = this.createMultipartFile(fileItem);
            multipartFiles.add(file.getName(), file);
        }
        return new MultipartParsingResult(multipartFiles, multipartParameters, multipartContentTypes);
    }

    protected StandardMultipartFile createMultipartFile(FileItem fileItem) {
        return new StandardMultipartFile(fileItem);
    }

    private String determineEncoding(String contentTypeHeader, String defaultEncoding) {
        if (TextUtils.isEmpty((CharSequence)contentTypeHeader)) {
            return defaultEncoding;
        }
        MediaType contentType = MediaType.parseMediaType(contentTypeHeader);
        Charset charset = contentType.getCharset();
        return charset != null ? charset.name() : defaultEncoding;
    }

    protected static class MultipartParsingResult {
        private final MultiValueMap<String, MultipartFile> multipartFiles;
        private final MultiValueMap<String, String> multipartParameters;
        private final Map<String, String> multipartContentTypes;

        public MultipartParsingResult(MultiValueMap<String, MultipartFile> mpFiles, MultiValueMap<String, String> mpParams, Map<String, String> mpParamContentTypes) {
            this.multipartFiles = mpFiles;
            this.multipartParameters = mpParams;
            this.multipartContentTypes = mpParamContentTypes;
        }

        public MultiValueMap<String, MultipartFile> getMultipartFiles() {
            return this.multipartFiles;
        }

        public MultiValueMap<String, String> getMultipartParameters() {
            return this.multipartParameters;
        }

        public Map<String, String> getMultipartContentTypes() {
            return this.multipartContentTypes;
        }
    }
}

