/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.http.multipart;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.http.HttpRequest;
import com.yanzhenjie.andserver.http.RequestWrapper;
import com.yanzhenjie.andserver.http.multipart.MultipartFile;
import com.yanzhenjie.andserver.http.multipart.MultipartRequest;
import com.yanzhenjie.andserver.util.LinkedMultiValueMap;
import com.yanzhenjie.andserver.util.MultiValueMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class StandardMultipartRequest
extends RequestWrapper
implements MultipartRequest {
    private HttpRequest mRequest;
    private MultiValueMap<String, MultipartFile> mMultipartFiles;
    private MultiValueMap<String, String> mMultipartParameters;
    private Map<String, String> mMultipartContentTypes;

    public StandardMultipartRequest(@NonNull HttpRequest request, @NonNull MultiValueMap<String, MultipartFile> mpFiles, @NonNull MultiValueMap<String, String> mpParams, @NonNull Map<String, String> mpContentTypes) {
        super(request);
        this.mRequest = request;
        this.mMultipartFiles = new LinkedMultiValueMap<String, MultipartFile>(Collections.unmodifiableMap(mpFiles));
        this.mMultipartParameters = new LinkedMultiValueMap<String, String>(Collections.unmodifiableMap(mpParams));
        this.mMultipartContentTypes = Collections.unmodifiableMap(mpContentTypes);
    }

    @Override
    @NonNull
    public Iterator<String> getFileNames() {
        return this.mMultipartFiles.keySet().iterator();
    }

    @Override
    @Nullable
    public MultipartFile getFile(String name) {
        return this.mMultipartFiles.getFirst(name);
    }

    @Override
    @Nullable
    public List<MultipartFile> getFiles(String name) {
        List multipartFiles = (List)this.mMultipartFiles.get(name);
        if (multipartFiles != null) {
            return multipartFiles;
        }
        return Collections.emptyList();
    }

    @Override
    @NonNull
    public Map<String, MultipartFile> getFileMap() {
        return this.mMultipartFiles.toSingleValueMap();
    }

    @Override
    @NonNull
    public MultiValueMap<String, MultipartFile> getMultiFileMap() {
        return this.mMultipartFiles;
    }

    @Override
    @Nullable
    public String getMultipartContentType(String paramOrFileName) {
        MultipartFile file = this.getFile(paramOrFileName);
        return file == null ? this.mMultipartContentTypes.get(paramOrFileName) : file.getContentType().getType();
    }

    @Override
    @NonNull
    public List<String> getParameterNames() {
        if (this.mMultipartParameters.isEmpty()) {
            return this.mRequest.getParameterNames();
        }
        LinkedList<String> paramNames = new LinkedList<String>();
        List<String> names = this.mRequest.getParameterNames();
        if (!names.isEmpty()) {
            paramNames.addAll(names);
        }
        paramNames.addAll(this.mMultipartParameters.keySet());
        return paramNames;
    }

    @Override
    @Nullable
    public String getParameter(@NonNull String name) {
        String value = this.mMultipartParameters.getFirst(name);
        return TextUtils.isEmpty((CharSequence)value) ? this.mRequest.getParameter(name) : value;
    }

    @Override
    @NonNull
    public List<String> getParameters(@NonNull String name) {
        List<String> values = (List<String>)this.mMultipartParameters.get(name);
        return values == null ? this.mRequest.getParameters(name) : values;
    }

    @Override
    @NonNull
    public MultiValueMap<String, String> getParameter() {
        return this.mMultipartParameters.isEmpty() ? this.mRequest.getParameter() : this.mMultipartParameters;
    }
}

