/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.http.multipart;

import androidx.annotation.NonNull;
import com.yanzhenjie.andserver.http.RequestBody;
import com.yanzhenjie.andserver.util.MediaType;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.fileupload.UploadContext;

public class BodyContext
implements UploadContext {
    private final RequestBody mBody;

    public BodyContext(@NonNull RequestBody body) {
        this.mBody = body;
    }

    public String getCharacterEncoding() {
        return this.mBody.contentEncoding();
    }

    public String getContentType() {
        MediaType contentType = this.mBody.contentType();
        return contentType == null ? null : contentType.toString();
    }

    public int getContentLength() {
        long contentLength = this.contentLength();
        return contentLength > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)contentLength;
    }

    public long contentLength() {
        return this.mBody.length();
    }

    public InputStream getInputStream() throws IOException {
        return this.mBody.stream();
    }

    public String toString() {
        return String.format("ContentLength=%s, Mime=%s", this.contentLength(), this.getContentType());
    }
}

