/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.http.cookie;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.Serializable;
import java.util.Locale;

public class Cookie
implements Cloneable,
Serializable {
    private static final String TSPECIALS = "/()<>@,;:\\\"[]?={} \t";
    private String name;
    private String value;
    private String comment;
    private String domain;
    private int maxAge = -1;
    private String path;
    private boolean secure;
    private int version = 0;
    private boolean isHttpOnly = false;

    public Cookie(@NonNull String name, @Nullable String value) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("The name of the cookie cannot be empty or null.");
        }
        if (!this.isToken(name) || name.equalsIgnoreCase("Comment") || name.equalsIgnoreCase("Discard") || name.equalsIgnoreCase("Domain") || name.equalsIgnoreCase("Expires") || name.equalsIgnoreCase("Max-Age") || name.equalsIgnoreCase("Path") || name.equalsIgnoreCase("Secure") || name.equalsIgnoreCase("Version") || name.startsWith("$")) {
            String message = String.format("This name [%1$s] is a reserved character.", name);
            throw new IllegalArgumentException(message);
        }
        this.name = name;
        this.value = value;
    }

    public void setComment(@Nullable String purpose) {
        this.comment = purpose;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    public void setDomain(@Nullable String domain) {
        this.domain = !TextUtils.isEmpty((CharSequence)domain) ? domain.toLowerCase(Locale.ENGLISH) : null;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    public void setMaxAge(int expiry) {
        this.maxAge = expiry;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setPath(@Nullable String path) {
        this.path = path;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public void setSecure(boolean flag) {
        this.secure = flag;
    }

    public boolean getSecure() {
        return this.secure;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public void setValue(@Nullable String newValue) {
        this.value = newValue;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int v) {
        this.version = v;
    }

    private boolean isToken(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' && TSPECIALS.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setHttpOnly(boolean isHttpOnly) {
        this.isHttpOnly = isHttpOnly;
    }

    public boolean isHttpOnly() {
        return this.isHttpOnly;
    }
}

