/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.http;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class AcceptLanguage {
    private final Locale locale;
    private final double quality;

    protected AcceptLanguage(Locale locale, double quality) {
        this.locale = locale;
        this.quality = quality;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public double getQuality() {
        return this.quality;
    }

    public static List<AcceptLanguage> parse(String input) {
        if (TextUtils.isEmpty((CharSequence)input)) {
            return Collections.emptyList();
        }
        String[] segments = input.split(",");
        if (segments.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<AcceptLanguage> list = new ArrayList<AcceptLanguage>();
        for (String segment : segments) {
            String[] values = segment.split(";");
            if (values.length != 2 || values[1].length() <= 2 || values[1].charAt(0) != 'q' || values[1].charAt(1) != '=') continue;
            String q = values[1].substring(2);
            try {
                list.add(new AcceptLanguage(new Locale(values[1]), Double.parseDouble(q)));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return list;
    }
}

