/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.framework.website;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.yanzhenjie.andserver.error.NotFoundException;
import com.yanzhenjie.andserver.framework.body.FileBody;
import com.yanzhenjie.andserver.framework.body.StringBody;
import com.yanzhenjie.andserver.framework.website.BasicWebsite;
import com.yanzhenjie.andserver.http.HttpRequest;
import com.yanzhenjie.andserver.http.HttpResponse;
import com.yanzhenjie.andserver.http.ResponseBody;
import com.yanzhenjie.andserver.util.Assert;
import com.yanzhenjie.andserver.util.DigestUtils;
import com.yanzhenjie.andserver.util.Patterns;
import java.io.File;
import java.io.IOException;

public class StorageWebsite
extends BasicWebsite
implements Patterns {
    private final String mRootPath;

    public StorageWebsite(@NonNull String rootPath) {
        this(rootPath, "index.html");
    }

    public StorageWebsite(@NonNull String rootPath, @NonNull String indexFileName) {
        super(indexFileName);
        Assert.isTrue(!TextUtils.isEmpty((CharSequence)rootPath), "The rootPath cannot be empty.");
        Assert.isTrue(rootPath.matches(PATH), "The format of [%s] is wrong, it should be like [/root/project].");
        this.mRootPath = rootPath;
    }

    @Override
    public boolean intercept(@NonNull HttpRequest request) {
        String httpPath = request.getPath();
        File file = this.findPathFile(httpPath);
        return file != null;
    }

    @Override
    public String getETag(@NonNull HttpRequest request) throws Throwable {
        String httpPath = request.getPath();
        File file = this.findPathFile(httpPath);
        if (file != null) {
            String tag = file.getAbsolutePath() + file.lastModified();
            return DigestUtils.md5DigestAsHex(tag);
        }
        return null;
    }

    @Override
    public long getLastModified(@NonNull HttpRequest request) throws Throwable {
        String httpPath = request.getPath();
        File file = this.findPathFile(httpPath);
        if (file != null) {
            return file.lastModified();
        }
        return -1L;
    }

    @Override
    @NonNull
    public ResponseBody getBody(@NonNull HttpRequest request, @NonNull HttpResponse response) throws IOException {
        String httpPath = request.getPath();
        File targetFile = new File(this.mRootPath, httpPath);
        if (targetFile.exists() && targetFile.isFile()) {
            return new FileBody(targetFile);
        }
        File indexFile = new File(targetFile, this.getIndexFileName());
        if (indexFile.exists() && indexFile.isFile()) {
            if (!httpPath.endsWith(File.separator)) {
                String redirectPath = this.addEndSlash(httpPath);
                String query = this.queryString(request);
                response.sendRedirect(redirectPath + "?" + query);
                return new StringBody("");
            }
            return new FileBody(indexFile);
        }
        throw new NotFoundException(httpPath);
    }

    private File findPathFile(@NonNull String httpPath) {
        File targetFile = new File(this.mRootPath, httpPath);
        if (targetFile.exists() && targetFile.isFile()) {
            return targetFile;
        }
        File indexFile = new File(targetFile, this.getIndexFileName());
        if (indexFile.exists() && indexFile.isFile()) {
            return indexFile;
        }
        return null;
    }
}

