/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.framework.mapping;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.yanzhenjie.andserver.util.Patterns;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Path
implements Patterns {
    private List<Rule> mRuleList = new LinkedList<Rule>();

    @NonNull
    public List<Rule> getRuleList() {
        return this.mRuleList;
    }

    public void addRule(@NonNull String ruleText) {
        Rule rule = new Rule();
        rule.setSegments(Path.pathToList(ruleText));
        this.mRuleList.add(rule);
    }

    @NonNull
    public static List<Segment> pathToList(@NonNull String path) {
        LinkedList<Segment> segmentList = new LinkedList<Segment>();
        if (!TextUtils.isEmpty((CharSequence)path)) {
            String[] pathArray;
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            while (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            for (String segmentText : pathArray = path.split("/")) {
                Segment segment = new Segment(segmentText, segmentText.contains("{"));
                segmentList.add(segment);
            }
        }
        return Collections.unmodifiableList(segmentList);
    }

    @NonNull
    public static String listToPath(@NonNull List<Segment> segments) {
        StringBuilder builder = new StringBuilder("");
        if (segments.isEmpty()) {
            builder.append("/");
        }
        for (Segment segment : segments) {
            builder.append("/").append(segment.getValue());
        }
        return builder.toString();
    }

    public static boolean matches(@NonNull String path1, @NonNull String path2) {
        if (path1.equals(path2)) {
            return true;
        }
        List<Segment> segments1 = Path.pathToList(path1);
        List<Segment> segments2 = Path.pathToList(path2);
        if (segments1.size() != segments2.size()) {
            return false;
        }
        boolean matches = true;
        for (int i = 0; i < segments1.size(); ++i) {
            Segment segment = segments1.get(i);
            if (segment.equals(segments2.get(i)) || segment.isBlurred()) continue;
            matches = false;
            break;
        }
        return matches;
    }

    public static class Segment {
        private final String value;
        private final boolean isBlurred;

        public Segment(String value, boolean isBlurred) {
            this.value = value;
            this.isBlurred = isBlurred;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isBlurred() {
            return this.isBlurred;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Segment)) {
                return false;
            }
            return this.value.equals(((Segment)obj).value);
        }

        public String toString() {
            return this.value;
        }
    }

    public static class Rule {
        private List<Segment> mSegments;

        public List<Segment> getSegments() {
            return this.mSegments;
        }

        public void setSegments(List<Segment> segments) {
            this.mSegments = segments;
        }
    }
}

