/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.framework.config;

import java.io.File;

public class Multipart {
    private final long allFileMaxSize;
    private final long fileMaxSize;
    private final int maxInMemorySize;
    private final File uploadTempDir;

    public static Builder newBuilder() {
        return new Builder();
    }

    private Multipart(Builder builder) {
        this.allFileMaxSize = builder.allFileMaxSize;
        this.fileMaxSize = builder.fileMaxSize;
        this.maxInMemorySize = builder.maxInMemorySize;
        this.uploadTempDir = builder.uploadTempDir;
    }

    public long getAllFileMaxSize() {
        return this.allFileMaxSize;
    }

    public long getFileMaxSize() {
        return this.fileMaxSize;
    }

    public int getMaxInMemorySize() {
        return this.maxInMemorySize;
    }

    public File getUploadTempDir() {
        return this.uploadTempDir;
    }

    public static class Builder {
        private long allFileMaxSize;
        private long fileMaxSize;
        private int maxInMemorySize;
        private File uploadTempDir;

        private Builder() {
        }

        public Builder allFileMaxSize(long allFileMaxSize) {
            this.allFileMaxSize = allFileMaxSize;
            return this;
        }

        public Builder fileMaxSize(long fileMaxSize) {
            this.fileMaxSize = fileMaxSize;
            return this;
        }

        public Builder maxInMemorySize(int maxInMemorySize) {
            this.maxInMemorySize = maxInMemorySize;
            return this;
        }

        public Builder uploadTempDir(File uploadTempDir) {
            this.uploadTempDir = uploadTempDir;
            return this;
        }

        public Multipart build() {
            return new Multipart(this);
        }
    }
}

