/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.framework.body;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.http.ResponseBody;
import com.yanzhenjie.andserver.util.IOUtils;
import com.yanzhenjie.andserver.util.MediaType;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamBody
implements ResponseBody {
    private InputStream mStream;
    private boolean mChunked;
    private long mLength;
    private MediaType mMediaType;

    public StreamBody(InputStream stream) {
        this(stream, MediaType.APPLICATION_OCTET_STREAM);
    }

    public StreamBody(InputStream stream, long length) {
        this(stream, length, MediaType.APPLICATION_OCTET_STREAM);
    }

    public StreamBody(InputStream stream, MediaType mediaType) {
        this(stream, true, 0L, mediaType);
    }

    public StreamBody(InputStream stream, long length, MediaType mediaType) {
        this(stream, false, length, mediaType);
    }

    public StreamBody(InputStream stream, boolean chunked, long length, MediaType mediaType) {
        this.mStream = stream;
        this.mChunked = chunked;
        this.mLength = length;
        this.mMediaType = mediaType;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public boolean isChunked() {
        return this.mChunked;
    }

    @Override
    public long contentLength() {
        if (this.mLength == 0L && this.mStream instanceof FileInputStream) {
            try {
                this.mLength = ((FileInputStream)this.mStream).getChannel().size();
                return this.mLength;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.mLength;
    }

    @Override
    @Nullable
    public MediaType contentType() {
        return this.mMediaType;
    }

    @Override
    public void writeTo(@NonNull OutputStream output) throws IOException {
        IOUtils.write(this.mStream, output);
        IOUtils.closeQuietly(this.mStream);
    }
}

