/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.framework;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.yanzhenjie.andserver.error.HttpException;
import com.yanzhenjie.andserver.error.MethodNotSupportException;
import com.yanzhenjie.andserver.framework.body.StringBody;
import com.yanzhenjie.andserver.http.HttpMethod;
import com.yanzhenjie.andserver.http.HttpRequest;
import com.yanzhenjie.andserver.http.HttpResponse;
import java.util.List;

public interface ExceptionResolver {
    public static final ExceptionResolver DEFAULT = new ExceptionResolver(){

        @Override
        public void onResolve(@NonNull HttpRequest request, @NonNull HttpResponse response, @NonNull Throwable e) {
            if (e instanceof HttpException) {
                HttpException ex = (HttpException)e;
                response.setStatus(ex.getStatusCode());
            } else {
                response.setStatus(500);
            }
            response.setBody(new StringBody(e.getMessage()));
        }
    };

    public void onResolve(@NonNull HttpRequest var1, @NonNull HttpResponse var2, @NonNull Throwable var3);

    public static class ResolverWrapper
    implements ExceptionResolver {
        private final ExceptionResolver mResolver;

        public ResolverWrapper(ExceptionResolver resolver) {
            this.mResolver = resolver;
        }

        @Override
        public void onResolve(@NonNull HttpRequest request, @NonNull HttpResponse response, @NonNull Throwable e) {
            List<HttpMethod> methods;
            if (e instanceof MethodNotSupportException && (methods = ((MethodNotSupportException)e).getMethods()) != null && methods.size() > 0) {
                response.setHeader("Allow", TextUtils.join((CharSequence)", ", methods));
            }
            this.mResolver.onResolve(request, response, e);
        }
    }
}

