/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.error.NotFoundException;
import com.yanzhenjie.andserver.error.ServerInternalException;
import com.yanzhenjie.andserver.framework.ExceptionResolver;
import com.yanzhenjie.andserver.framework.HandlerInterceptor;
import com.yanzhenjie.andserver.framework.MessageConverter;
import com.yanzhenjie.andserver.framework.ModifiedInterceptor;
import com.yanzhenjie.andserver.framework.body.StringBody;
import com.yanzhenjie.andserver.framework.config.Multipart;
import com.yanzhenjie.andserver.framework.handler.HandlerAdapter;
import com.yanzhenjie.andserver.framework.handler.RequestHandler;
import com.yanzhenjie.andserver.framework.view.View;
import com.yanzhenjie.andserver.framework.view.ViewResolver;
import com.yanzhenjie.andserver.http.HttpRequest;
import com.yanzhenjie.andserver.http.HttpResponse;
import com.yanzhenjie.andserver.http.RequestDispatcher;
import com.yanzhenjie.andserver.http.RequestWrapper;
import com.yanzhenjie.andserver.http.StandardContext;
import com.yanzhenjie.andserver.http.StandardRequest;
import com.yanzhenjie.andserver.http.StandardResponse;
import com.yanzhenjie.andserver.http.cookie.Cookie;
import com.yanzhenjie.andserver.http.multipart.MultipartRequest;
import com.yanzhenjie.andserver.http.multipart.MultipartResolver;
import com.yanzhenjie.andserver.http.multipart.StandardMultipartResolver;
import com.yanzhenjie.andserver.http.session.Session;
import com.yanzhenjie.andserver.http.session.SessionManager;
import com.yanzhenjie.andserver.http.session.StandardSessionManager;
import com.yanzhenjie.andserver.register.Register;
import com.yanzhenjie.andserver.util.Assert;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.httpcore.protocol.HttpContext;
import org.apache.httpcore.protocol.HttpRequestHandler;

public class DispatcherHandler
implements HttpRequestHandler,
Register {
    private final Context mContext;
    private SessionManager mSessionManager;
    private MessageConverter mConverter;
    private ViewResolver mViewResolver;
    private ExceptionResolver mResolver;
    private Multipart mMultipart;
    private List<HandlerAdapter> mAdapterList = new LinkedList<HandlerAdapter>();
    private List<HandlerInterceptor> mInterceptorList = new LinkedList<HandlerInterceptor>();

    public DispatcherHandler(Context context) {
        this.mContext = context;
        this.mSessionManager = new StandardSessionManager(context);
        this.mViewResolver = new ViewResolver();
        this.mResolver = new ExceptionResolver.ResolverWrapper(ExceptionResolver.DEFAULT);
        this.mInterceptorList.add(new ModifiedInterceptor());
    }

    @Override
    public void addAdapter(@NonNull HandlerAdapter adapter) {
        Assert.notNull(adapter, "The adapter cannot be null.");
        if (!this.mAdapterList.contains(adapter)) {
            this.mAdapterList.add(adapter);
        }
    }

    @Override
    public void addInterceptor(@NonNull HandlerInterceptor interceptor) {
        Assert.notNull(interceptor, "The interceptor cannot be null.");
        if (!this.mInterceptorList.contains(interceptor)) {
            this.mInterceptorList.add(interceptor);
        }
    }

    @Override
    public void setConverter(MessageConverter converter) {
        this.mConverter = converter;
        this.mViewResolver = new ViewResolver(converter);
    }

    @Override
    public void setResolver(@NonNull ExceptionResolver resolver) {
        Assert.notNull(resolver, "The exceptionResolver cannot be null.");
        this.mResolver = new ExceptionResolver.ResolverWrapper(resolver);
    }

    @Override
    public void setMultipart(Multipart multipart) {
        this.mMultipart = multipart;
    }

    public void handle(org.apache.httpcore.HttpRequest req, org.apache.httpcore.HttpResponse res, HttpContext con) {
        StandardRequest request = new StandardRequest(req, new StandardContext(con), this, this.mSessionManager);
        StandardResponse response = new StandardResponse(res);
        this.handle(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(HttpRequest request, HttpResponse response) {
        StandardMultipartResolver multipartResolver = new StandardMultipartResolver();
        try {
            HandlerAdapter ha;
            if (multipartResolver.isMultipart(request)) {
                this.configMultipart(multipartResolver);
                request = multipartResolver.resolveMultipart(request);
            }
            if ((ha = this.getHandlerAdapter(request)) == null) {
                throw new NotFoundException(request.getPath());
            }
            RequestHandler handler = ha.getHandler(request);
            if (handler == null) {
                throw new NotFoundException(request.getPath());
            }
            if (this.preHandle(request, response, handler)) {
                return;
            }
            request.setAttribute("android.context", this.mContext);
            request.setAttribute("http.message.converter", this.mConverter);
            View view = handler.handle(request, response);
            this.mViewResolver.resolve(view, request, response);
            this.processSession(request, response);
        }
        catch (Throwable err) {
            try {
                this.mResolver.onResolve(request, response, err);
            }
            catch (Exception e2) {
                ServerInternalException e2 = new ServerInternalException(e2);
                response.setStatus(500);
                response.setBody(new StringBody(e2.getMessage()));
            }
            this.processSession(request, response);
        }
        finally {
            if (request instanceof MultipartRequest) {
                multipartResolver.cleanupMultipart((MultipartRequest)request);
            }
        }
    }

    private void configMultipart(MultipartResolver multipartResolver) {
        if (this.mMultipart != null) {
            File uploadTempDir;
            int maxInMemorySize;
            long fileMaxSize;
            long allFileMaxSize = this.mMultipart.getAllFileMaxSize();
            if (allFileMaxSize == -1L || allFileMaxSize > 0L) {
                multipartResolver.setAllFileMaxSize(allFileMaxSize);
            }
            if ((fileMaxSize = this.mMultipart.getFileMaxSize()) == -1L || fileMaxSize > 0L) {
                multipartResolver.setFileMaxSize(fileMaxSize);
            }
            if ((maxInMemorySize = this.mMultipart.getMaxInMemorySize()) > 0) {
                multipartResolver.setMaxInMemorySize(maxInMemorySize);
            }
            if ((uploadTempDir = this.mMultipart.getUploadTempDir()) != null) {
                multipartResolver.setUploadTempDir(uploadTempDir);
            }
        }
    }

    private HandlerAdapter getHandlerAdapter(HttpRequest request) {
        for (HandlerAdapter ha : this.mAdapterList) {
            if (!ha.intercept(request)) continue;
            return ha;
        }
        return null;
    }

    private boolean preHandle(HttpRequest request, HttpResponse response, RequestHandler handler) throws Exception {
        for (HandlerInterceptor interceptor : this.mInterceptorList) {
            if (!interceptor.onIntercept(request, response, handler)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public RequestDispatcher getRequestDispatcher(HttpRequest request, String path) {
        HttpRequest copyRequest = request;
        while (copyRequest instanceof RequestWrapper) {
            RequestWrapper wrapper = (RequestWrapper)request;
            copyRequest = wrapper.getRequest();
        }
        StandardRequest newRequest = (StandardRequest)copyRequest;
        newRequest.setPath(path);
        HandlerAdapter ha = this.getHandlerAdapter(copyRequest);
        if (ha == null) {
            throw new NotFoundException(request.getPath());
        }
        return new RequestDispatcher(){

            @Override
            public void forward(@NonNull HttpRequest request, @NonNull HttpResponse response) {
                DispatcherHandler.this.handle(request, response);
            }
        };
    }

    private void processSession(HttpRequest request, HttpResponse response) {
        Object objSession = request.getAttribute("http.request.Session");
        if (objSession instanceof Session) {
            Session session = (Session)objSession;
            try {
                this.mSessionManager.add(session);
            }
            catch (IOException e) {
                Log.e((String)"AndServer", (String)"Session persistence failed.", (Throwable)e);
            }
            Cookie cookie = new Cookie("ASESSIONID", session.getId());
            cookie.setPath("/");
            cookie.setHttpOnly(true);
            response.addCookie(cookie);
        }
    }
}

