/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.security.tool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;

public class CliUtils {
    public static String optionOrThrow(CommandLine arguments, String option) {
        String value = arguments.getOptionValue(option);
        if (value == null) {
            throw new IllegalArgumentException("Required argument '--%s' must be provided".formatted(option));
        }
        return value;
    }

    public static InputStream inputStreamFromFileOrStream(String pathOrDash, InputStream stdIn) throws IOException {
        if ("-".equals(pathOrDash)) {
            return stdIn;
        }
        Path inputPath = Paths.get(pathOrDash, new String[0]);
        if (!Files.exists(inputPath, new LinkOption[0])) {
            throw new IllegalArgumentException("Input file '%s' does not exist".formatted(inputPath.toString()));
        }
        return Files.newInputStream(inputPath, new OpenOption[0]);
    }

    public static OutputStream outputStreamToFileOrStream(String pathOrDash, OutputStream stdOut) throws IOException {
        if ("-".equals(pathOrDash)) {
            return stdOut;
        }
        return Files.newOutputStream(Paths.get(pathOrDash, new String[0]), new OpenOption[0]);
    }
}

