/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.vespasignificance.common;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;

public final class VespaSignificanceTsvWriter
implements AutoCloseable {
    private final BufferedWriter bw;
    private final boolean sorted;
    private String lastTerm;
    public static final String MAGIC = "#VESPA_SIGNIFICANCE_TSV";
    public static final String VERSION = "v1";
    public static final String HEADER_END = "--END-HEADER--";

    public VespaSignificanceTsvWriter(Path out, long documentCount, boolean sorted, Instant createdAt) throws IOException {
        this.bw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(out, new OpenOption[0]), StandardCharsets.UTF_8));
        this.sorted = sorted;
        this.writeHeader(documentCount, sorted, createdAt);
    }

    public VespaSignificanceTsvWriter(Writer writer, long documentCount, boolean sorted, Instant createdAt) throws IOException {
        this.bw = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, 65536);
        this.sorted = sorted;
        this.writeHeader(documentCount, sorted, createdAt);
    }

    private void writeHeader(long documentCount, boolean sorted, Instant createdAt) throws IOException {
        this.bw.write(MAGIC);
        this.bw.write(9);
        this.bw.write(VERSION);
        this.bw.write(10);
        this.bw.write("document_count");
        this.bw.write("\t");
        this.bw.write(Long.toString(documentCount));
        this.bw.write(10);
        this.bw.write("sorted");
        this.bw.write("\t");
        this.bw.write(sorted ? "true" : "false");
        this.bw.write(10);
        this.bw.write("created_at");
        this.bw.write("\t");
        this.bw.write(Objects.requireNonNull(createdAt, "created_at").toString());
        this.bw.write(10);
        this.bw.write(HEADER_END);
        this.bw.write(10);
    }

    public void writeRow(String term, long df) throws IOException {
        if (term == null || term.isEmpty()) {
            throw new IllegalArgumentException("term is empty");
        }
        if (term.indexOf(9) >= 0) {
            throw new IllegalArgumentException("term contains tab");
        }
        if (df < 0L) {
            throw new IllegalArgumentException("negative df");
        }
        if (this.sorted && this.lastTerm != null && term.compareTo(this.lastTerm) <= 0) {
            throw new IllegalArgumentException("Not strictly ascending: '" + term + "' <= '" + this.lastTerm + "'");
        }
        this.lastTerm = term;
        this.bw.write(term);
        this.bw.write(9);
        this.bw.write(Long.toString(df));
        this.bw.write(10);
    }

    public void flush() throws IOException {
        this.bw.flush();
    }

    @Override
    public void close() throws IOException {
        this.bw.close();
    }
}

