/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespasignificance;

import ai.vespa.vespasignificance.export.Export;
import ai.vespa.vespasignificance.export.ExportClientParameters;
import com.yahoo.vespasignificance.ClientParameters;
import com.yahoo.vespasignificance.CommandLineOptions;
import com.yahoo.vespasignificance.SignificanceModelGenerator;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.ParseException;

public class Main {
    public static void main(String[] args) {
        CommandLine global;
        DefaultParser parser = new DefaultParser();
        try {
            global = parser.parse(CommandLineOptions.createGlobalOptions(), args, true);
        }
        catch (ParseException e) {
            System.err.println("Parsing failed. Reason: " + e.getMessage());
            CommandLineOptions.printGlobalHelp();
            System.exit(1);
            return;
        }
        String[] remaining = global.getArgs();
        if (remaining.length == 0 || global.hasOption("help")) {
            CommandLineOptions.printGlobalHelp();
            return;
        }
        String sub = remaining[0];
        String[] subArgs = Arrays.copyOfRange(remaining, 1, remaining.length);
        switch (sub) {
            case "generate": {
                Main.runGenerate(subArgs);
                break;
            }
            case "export": {
                Main.runExport(subArgs);
                break;
            }
            default: {
                System.err.println("Error: Unknown command `" + sub + "`");
                CommandLineOptions.printGlobalHelp();
            }
        }
    }

    static void runGenerate(String[] commandLineArgs) {
        try {
            if (CommandLineOptions.Utils.hasHelpOption(commandLineArgs)) {
                CommandLineOptions.printGenerateHelp();
                return;
            }
            DefaultParser commandLineParser = new DefaultParser();
            CommandLine commandLine = commandLineParser.parse(CommandLineOptions.createGenerateOptions(), commandLineArgs);
            ClientParameters params = CommandLineOptions.parseGenerateCommandLineArguments(commandLine);
            System.setProperty("vespa.replace_invalid_unicode", "true");
            SignificanceModelGenerator significanceModelGenerator = Main.createSignificanceModelGenerator(params);
            significanceModelGenerator.generate();
        }
        catch (ParseException e) {
            System.err.printf("Error: %s.\n", e.getMessage());
            CommandLineOptions.printGenerateHelp();
            System.exit(1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static SignificanceModelGenerator createSignificanceModelGenerator(ClientParameters params) {
        return new SignificanceModelGenerator(params);
    }

    static void runExport(String[] commandLineArgs) {
        try {
            if (CommandLineOptions.Utils.hasHelpOption(commandLineArgs)) {
                CommandLineOptions.printExportHelp();
                return;
            }
            DefaultParser commandLineParser = new DefaultParser();
            CommandLine commandLine = commandLineParser.parse(CommandLineOptions.createExportOptions(), commandLineArgs);
            System.setProperty("vespa.replace_invalid_unicode", "true");
            ExportClientParameters clientParams = CommandLineOptions.parseExportCommandLineArguments(commandLine);
            Export export = new Export(clientParams);
            System.exit(export.run());
        }
        catch (ParseException e) {
            System.err.printf("Error: %s.\n", e.getMessage());
            CommandLineOptions.printExportHelp();
            System.exit(1);
        }
    }
}

