/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespastat;

import com.yahoo.document.FixedBucketSpaces;

public class ClientParameters {
    public final boolean help;
    public final boolean dumpData;
    public final String route;
    public final SelectionType selectionType;
    public final String id;
    public final String bucketSpace;

    public ClientParameters(boolean help, boolean dumpData, String route, SelectionType selectionType, String id) {
        this(help, dumpData, route, selectionType, id, FixedBucketSpaces.defaultSpace());
    }

    public ClientParameters(boolean help, boolean dumpData, String route, SelectionType selectionType, String id, String bucketSpace) {
        this.help = help;
        this.dumpData = dumpData;
        this.route = route;
        this.selectionType = selectionType;
        this.id = id;
        this.bucketSpace = bucketSpace;
    }

    public static enum SelectionType {
        USER,
        GROUP,
        BUCKET,
        GID,
        DOCUMENT;

    }

    public static class Builder {
        private boolean help;
        private boolean dumpData;
        private String route;
        private SelectionType selectionType;
        private String id;
        private String bucketSpace = FixedBucketSpaces.defaultSpace();

        public Builder setHelp(boolean help) {
            this.help = help;
            return this;
        }

        public Builder setDumpData(boolean dumpData) {
            this.dumpData = dumpData;
            return this;
        }

        public Builder setRoute(String route) {
            this.route = route;
            return this;
        }

        public Builder setSelectionType(SelectionType selectionType) {
            this.selectionType = selectionType;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setBucketSpace(String bucketSpace) {
            this.bucketSpace = bucketSpace;
            return this;
        }

        public ClientParameters build() {
            return new ClientParameters(this.help, this.dumpData, this.route, this.selectionType, this.id, this.bucketSpace);
        }
    }
}

