/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.security.tool.crypto;

import com.yahoo.compress.ZstdOutputStream;
import com.yahoo.security.AeadCipher;
import io.airlift.compress.zstd.ZstdInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CipherUtils {
    public static void streamEncipher(InputStream input, OutputStream output, AeadCipher cipher) throws IOException {
        try (OutputStream cipherStream = cipher.wrapOutputStream(output);){
            input.transferTo(cipherStream);
            cipherStream.flush();
        }
    }

    private static OutputStream maybeWrapCompress(OutputStream out, boolean compressZstd) throws IOException {
        return compressZstd ? new ZstdOutputStream(out) : out;
    }

    public static void streamEncrypt(InputStream input, OutputStream output, AeadCipher cipher, boolean compressZstd) throws IOException {
        try (OutputStream out = CipherUtils.maybeWrapCompress(cipher.wrapOutputStream(output), compressZstd);){
            input.transferTo(out);
            out.flush();
        }
    }

    private static InputStream maybeWrapDecompress(InputStream in, boolean decompressZstd) throws IOException {
        return decompressZstd ? new ZstdInputStream(in) : in;
    }

    public static void streamDecrypt(InputStream input, OutputStream output, AeadCipher cipher, boolean decompressZstd) throws IOException {
        try (InputStream in = CipherUtils.maybeWrapDecompress(cipher.wrapInputStream(input), decompressZstd);){
            in.transferTo(output);
            output.flush();
        }
    }
}

