/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespavisit;

import com.yahoo.documentapi.ProgressToken;
import com.yahoo.documentapi.VisitorControlHandler;
import com.yahoo.documentapi.VisitorDataHandler;
import com.yahoo.vdslib.VisitorStatistics;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public abstract class VdsVisitHandler {
    boolean showProgress;
    boolean showStatistics;
    boolean abortOnClusterDown;
    boolean lastLineIsProgress = false;
    String lastPercentage;
    final Object printLock = new Object();
    protected String progressFileName = "";
    final VisitorControlHandler controlHandler = new ControlHandler();

    public VdsVisitHandler(boolean showProgress, boolean showStatistics, boolean abortOnClusterDown) {
        this.showProgress = showProgress;
        this.showStatistics = showStatistics;
        this.abortOnClusterDown = abortOnClusterDown;
    }

    public boolean getShowProgress() {
        return this.showProgress;
    }

    public boolean getShowStatistics() {
        return this.showStatistics;
    }

    public boolean getAbortOnClusterDown() {
        return this.abortOnClusterDown;
    }

    public boolean getLastLineIsProgress() {
        return this.lastLineIsProgress;
    }

    public void setLastLineIsProgress(boolean isProgress) {
        this.lastLineIsProgress = isProgress;
    }

    public String getLastPercentage() {
        return this.lastPercentage;
    }

    public void setLastPercentage(String lastPercentage) {
        this.lastPercentage = lastPercentage;
    }

    public Object getPrintLock() {
        return this.printLock;
    }

    public void onDone() {
    }

    public String getProgressFileName() {
        return this.progressFileName;
    }

    public void setProgressFileName(String progressFileName) {
        this.progressFileName = progressFileName;
    }

    public VisitorControlHandler getControlHandler() {
        return this.controlHandler;
    }

    public abstract VisitorDataHandler getDataHandler();

    class ControlHandler
    extends VisitorControlHandler {
        VisitorStatistics statistics;

        ControlHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProgress(ProgressToken token) {
            Object object;
            if (VdsVisitHandler.this.progressFileName.length() > 0) {
                try {
                    object = token;
                    synchronized (object) {
                        File file = new File(VdsVisitHandler.this.progressFileName + ".tmp");
                        FileOutputStream fos = new FileOutputStream(file);
                        fos.write(token.toString().getBytes());
                        fos.close();
                        file.renameTo(new File(VdsVisitHandler.this.progressFileName));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (VdsVisitHandler.this.showProgress) {
                object = VdsVisitHandler.this.printLock;
                synchronized (object) {
                    DecimalFormat df = new DecimalFormat("#.#");
                    String percentage = df.format(token.percentFinished());
                    if (!percentage.equals(VdsVisitHandler.this.lastPercentage)) {
                        if (VdsVisitHandler.this.lastLineIsProgress) {
                            System.err.print('\r');
                        }
                        System.err.print(percentage + " % finished.");
                        VdsVisitHandler.this.lastLineIsProgress = true;
                        VdsVisitHandler.this.lastPercentage = percentage;
                    }
                }
            }
            super.onProgress(token);
        }

        public void onVisitorStatistics(VisitorStatistics visitorStatistics) {
            this.statistics = visitorStatistics;
        }

        private String getDateTime() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzz");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date date = new Date();
            return dateFormat.format(date);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onVisitorError(String message) {
            Object object = VdsVisitHandler.this.printLock;
            synchronized (object) {
                if (VdsVisitHandler.this.lastLineIsProgress) {
                    System.err.print('\r');
                    VdsVisitHandler.this.lastLineIsProgress = false;
                }
                System.err.println("Visitor error (" + this.getDateTime() + "): " + message);
                if (VdsVisitHandler.this.abortOnClusterDown && !this.isDone() && (message.lastIndexOf("Could not resolve") >= 0 || message.lastIndexOf("don't allow external load") >= 0)) {
                    System.err.println("Aborting visitor as --abortonclusterdown flag is set.");
                    this.abort();
                }
            }
        }

        public void onDone(VisitorControlHandler.CompletionCode code, String message) {
            if (VdsVisitHandler.this.lastLineIsProgress) {
                System.err.print('\n');
                VdsVisitHandler.this.lastLineIsProgress = false;
            }
            if (code != VisitorControlHandler.CompletionCode.SUCCESS) {
                if (code == VisitorControlHandler.CompletionCode.ABORTED) {
                    System.err.println("Visitor aborted: " + message);
                } else if (code == VisitorControlHandler.CompletionCode.TIMEOUT) {
                    System.err.println("Visitor timed out: " + message);
                } else {
                    System.err.println("Visitor aborted due to unknown issue " + code + ": " + message);
                }
            } else {
                if (VdsVisitHandler.this.showProgress) {
                    System.err.println("Completed visiting.");
                }
                if (VdsVisitHandler.this.showStatistics) {
                    System.err.println("*** Visitor statistics");
                    System.err.println(this.statistics == null ? "Nothing visited" : this.statistics.toString());
                }
            }
            super.onDone(code, message);
        }
    }
}

