/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespafeeder;

import com.yahoo.clientmetrics.MessageTypeMetricSet;
import com.yahoo.clientmetrics.RouteMetricSet;
import com.yahoo.concurrent.Timer;
import java.io.PrintStream;

public class BenchmarkProgressPrinter
implements RouteMetricSet.ProgressCallback {
    private final long startTime;
    private final Timer timer;
    private final PrintStream output;

    public BenchmarkProgressPrinter(Timer timer, PrintStream output) {
        this.timer = timer;
        this.output = output;
        this.startTime = timer.milliTime();
    }

    private void printMetrics(PrintStream out, RouteMetricSet metrics) {
        for (MessageTypeMetricSet m : metrics.getMetrics().values()) {
            long timeUsed = this.timer.milliTime() - this.startTime;
            out.println(timeUsed + ", " + m.count + ", " + m.errorCount + ", " + m.latency_min + ", " + m.latency_max + ", " + m.latency_total / Long.max(1L, m.count));
        }
    }

    public void onProgress(RouteMetricSet metrics) {
    }

    public void done(RouteMetricSet metrics) {
        try {
            this.output.println("# Time used, num ok, num error, min latency, max latency, average latency");
            this.printMetrics(this.output, metrics);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

