/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespafeeder;

import com.yahoo.clientmetrics.RouteMetricSet;
import com.yahoo.concurrent.SystemTimer;
import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.concurrent.Timer;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentTypeManagerConfigurer;
import com.yahoo.feedapi.FeedContext;
import com.yahoo.feedhandler.FeedResponse;
import com.yahoo.feedhandler.NullFeedMetric;
import com.yahoo.feedhandler.VespaFeedHandler;
import com.yahoo.jdisc.Metric;
import com.yahoo.log.LogSetup;
import com.yahoo.vespaclient.ClusterList;
import com.yahoo.vespafeeder.Arguments;
import com.yahoo.vespafeeder.BenchmarkProgressPrinter;
import com.yahoo.vespafeeder.FileRequest;
import com.yahoo.vespafeeder.InputStreamRequest;
import com.yahoo.vespafeeder.ProgressPrinter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class VespaFeeder {
    Arguments args;
    DocumentTypeManager manager;
    Executor threadPool = Executors.newCachedThreadPool(ThreadFactoryFactory.getThreadFactory((String)"vespa-feeder"));

    public VespaFeeder(Arguments args, DocumentTypeManager manager) {
        this.args = args;
        this.manager = manager;
    }

    static FeedErrorException renderErrors(List<String> errors) {
        StringBuilder buffer = new StringBuilder();
        if (!errors.isEmpty()) {
            int i;
            String headline = errors.size() > 10 ? "First 10 errors (of " + errors.size() + "):" : "Errors:";
            buffer.append(headline).append("\n");
            for (i = 0; i < headline.length(); ++i) {
                buffer.append("-");
            }
            buffer.append("\n");
            for (i = 0; i < errors.size() && i < 10; ++i) {
                buffer.append("    ").append(errors.get(i)).append("\n");
            }
        }
        return new FeedErrorException(buffer.toString());
    }

    public RouteMetricSet.ProgressCallback createProgressCallback(PrintStream output) {
        if ("benchmark".equals(this.args.getMode())) {
            return new BenchmarkProgressPrinter((Timer)SystemTimer.INSTANCE, output);
        }
        return new ProgressPrinter((Timer)SystemTimer.INSTANCE, output);
    }

    void parseFiles(InputStream stdin, PrintStream output) throws Exception {
        FeedContext context = new FeedContext(this.args.getPropertyProcessor(), this.args.getSessionFactory(), this.manager, new ClusterList(), (Metric)new NullFeedMetric(true));
        BufferedInputStream input = new BufferedInputStream(stdin);
        VespaFeedHandler handler = VespaFeedHandler.createFromContext((FeedContext)context, (Executor)this.threadPool);
        if (this.args.getFiles().isEmpty()) {
            InputStreamRequest req = new InputStreamRequest(input);
            this.setProperties(req, input);
            FeedResponse response = (FeedResponse)handler.handle(req.toRequest(), this.createProgressCallback(output), this.args.getNumThreads());
            if (!response.isSuccess()) {
                throw VespaFeeder.renderErrors(response.getErrorList());
            }
        } else {
            if (this.args.isVerbose()) {
                for (String fileName : this.args.getFiles()) {
                    long thisSize = new File(fileName).length();
                    output.println("Size of file '" + fileName + "' is " + thisSize + " B.");
                }
            }
            for (String fileName : this.args.getFiles()) {
                File f = new File(fileName);
                FileRequest req = new FileRequest(f);
                BufferedInputStream inputSnooper = new BufferedInputStream(new FileInputStream(fileName));
                this.setProperties(req, inputSnooper);
                inputSnooper.close();
                FeedResponse response = (FeedResponse)handler.handle(req.toRequest(), this.createProgressCallback(output), this.args.getNumThreads());
                if (response.isSuccess()) continue;
                throw VespaFeeder.renderErrors(response.getErrorList());
            }
        }
    }

    private void setProperties(InputStreamRequest req, BufferedInputStream input) throws IOException {
        this.setPriority(req);
        this.setCreateIfNonExistent(req);
        VespaFeeder.setJsonInput(req, input);
        req.setProperty("totaltimeout", "-1");
    }

    private void setPriority(InputStreamRequest req) {
        if (this.args.getPriority() != null) {
            req.setProperty("priority", this.args.getPriority());
        }
    }

    private void setCreateIfNonExistent(InputStreamRequest req) {
        if (this.args.getFeederConfig().createifnonexistent()) {
            req.setProperty("createifnonexistent", "true");
        }
    }

    static void setJsonInput(InputStreamRequest req, BufferedInputStream input) throws IOException {
        input.mark(4);
        int b = input.read();
        input.reset();
        if (b == 91) {
            req.setProperty("jsonInput", Boolean.TRUE.toString());
        } else {
            req.setProperty("jsonInput", Boolean.FALSE.toString());
        }
    }

    public static void main(String[] args) {
        LogSetup.initVespaLogging((String)"vespa-feeder");
        try {
            Arguments arguments = new Arguments(args, null);
            DocumentTypeManager manager = new DocumentTypeManager();
            DocumentTypeManagerConfigurer.configure((DocumentTypeManager)manager, (String)"client").close();
            VespaFeeder feeder = new VespaFeeder(arguments, manager);
            feeder.parseFiles(System.in, System.out);
            System.exit(0);
        }
        catch (Arguments.HelpShownException e) {
            System.exit(0);
        }
        catch (IllegalArgumentException e) {
            System.exit(1);
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not open file " + e.getMessage());
            System.exit(1);
        }
        catch (FeedErrorException e) {
            System.err.println("\n" + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Got exception " + e.getMessage() + ", aborting feed.");
            System.exit(1);
        }
    }

    public static class FeedErrorException
    extends Exception {
        String message;

        public FeedErrorException(String message) {
            this.message = message;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

