/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import com.yahoo.security.TrustManagerUtils;
import com.yahoo.security.X509CertificateUtils;
import com.yahoo.security.tls.AuthorizationMode;
import com.yahoo.security.tls.AuthorizedPeers;
import com.yahoo.security.tls.ConnectionAuthContext;
import com.yahoo.security.tls.HostnameVerification;
import com.yahoo.security.tls.PeerAuthorizationFailedException;
import com.yahoo.security.tls.PeerAuthorizer;
import java.net.Socket;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;

class PeerAuthorizerTrustManager
extends X509ExtendedTrustManager {
    static final String AUTH_CONTEXT_PROPERTY = "vespa.tls.auth.ctx";
    private static final Logger log = Logger.getLogger(PeerAuthorizerTrustManager.class.getName());
    private final PeerAuthorizer authorizer;
    private final X509ExtendedTrustManager defaultTrustManager;
    private final AuthorizationMode mode;
    private final HostnameVerification hostnameVerification;

    PeerAuthorizerTrustManager(AuthorizedPeers authorizedPeers, AuthorizationMode mode, HostnameVerification hostnameVerification, X509ExtendedTrustManager defaultTrustManager) {
        this.authorizer = new PeerAuthorizer(authorizedPeers);
        this.mode = mode;
        this.hostnameVerification = hostnameVerification;
        this.defaultTrustManager = defaultTrustManager;
    }

    PeerAuthorizerTrustManager(AuthorizedPeers authorizedPeers, AuthorizationMode mode, HostnameVerification hostnameVerification, KeyStore truststore) {
        this(authorizedPeers, mode, hostnameVerification, TrustManagerUtils.createDefaultX509TrustManager(truststore));
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.defaultTrustManager.checkClientTrusted(chain, authType);
        this.authorizePeer(chain, authType, true, null);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.defaultTrustManager.checkServerTrusted(chain, authType);
        this.authorizePeer(chain, authType, false, null);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.defaultTrustManager.checkClientTrusted(chain, authType, socket);
        this.authorizePeer(chain, authType, true, ((SSLSocket)socket).getHandshakeSession());
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.overrideHostnameVerificationForClient(socket);
        this.defaultTrustManager.checkServerTrusted(chain, authType, socket);
        this.authorizePeer(chain, authType, false, ((SSLSocket)socket).getHandshakeSession());
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.defaultTrustManager.checkClientTrusted(chain, authType, sslEngine);
        this.authorizePeer(chain, authType, true, sslEngine.getHandshakeSession());
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.overrideHostnameVerificationForClient(sslEngine);
        this.defaultTrustManager.checkServerTrusted(chain, authType, sslEngine);
        this.authorizePeer(chain, authType, false, sslEngine.getHandshakeSession());
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }

    private void authorizePeer(X509Certificate[] certChain, String authType, boolean isVerifyingClient, SSLSession handshakeSessionOrNull) throws PeerAuthorizationFailedException {
        ConnectionAuthContext result;
        log.fine(() -> "Verifying certificate: " + this.createInfoString(certChain[0], authType, isVerifyingClient));
        ConnectionAuthContext connectionAuthContext = result = this.mode != AuthorizationMode.DISABLE ? this.authorizer.authorizePeer(List.of(certChain)) : ConnectionAuthContext.defaultAllCapabilities(List.of(certChain));
        if (handshakeSessionOrNull != null) {
            handshakeSessionOrNull.putValue(AUTH_CONTEXT_PROPERTY, result);
        } else {
            log.log(Level.FINE, () -> "Warning: unable to provide ConnectionAuthContext as no SSLSession is available");
        }
        if (result.authorized()) {
            log.fine(() -> String.format("Verification result: %s", result));
        } else {
            String errorMessage = "Authorization failed: " + this.createInfoString(certChain[0], authType, isVerifyingClient);
            log.warning(errorMessage);
            if (this.mode == AuthorizationMode.ENFORCE) {
                throw new PeerAuthorizationFailedException(errorMessage, List.of(certChain));
            }
        }
    }

    private String createInfoString(X509Certificate certificate, String authType, boolean isVerifyingClient) {
        return String.format("DN='%s', SANs=%s, authType='%s', isVerifyingClient='%b', mode=%s", new Object[]{certificate.getSubjectX500Principal(), X509CertificateUtils.getSubjectAlternativeNames(certificate), authType, isVerifyingClient, this.mode});
    }

    private void overrideHostnameVerificationForClient(SSLEngine engine) {
        SSLParameters params = engine.getSSLParameters();
        if (this.overrideHostnameVerificationForClient(params)) {
            engine.setSSLParameters(params);
        }
    }

    private void overrideHostnameVerificationForClient(Socket socket) {
        SSLSocket sslSocket;
        SSLParameters params;
        if (socket instanceof SSLSocket && this.overrideHostnameVerificationForClient(params = (sslSocket = (SSLSocket)socket).getSSLParameters())) {
            sslSocket.setSSLParameters(params);
        }
    }

    private boolean overrideHostnameVerificationForClient(SSLParameters params) {
        String configuredAlgorithm = params.getEndpointIdentificationAlgorithm();
        switch (this.hostnameVerification) {
            case ENABLED: {
                if (!"HTTPS".equals(configuredAlgorithm)) {
                    params.setEndpointIdentificationAlgorithm("HTTPS");
                    return true;
                }
                return false;
            }
            case DISABLED: {
                if (configuredAlgorithm != null && !configuredAlgorithm.isEmpty()) {
                    params.setEndpointIdentificationAlgorithm("");
                    return true;
                }
                return false;
            }
        }
        throw new IllegalStateException("Unknown host verification type: " + String.valueOf((Object)this.hostnameVerification));
    }
}

