/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.hpke;

import com.yahoo.security.ArrayUtils;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.hpke.Constants;
import com.yahoo.security.hpke.HkdfSha256;
import com.yahoo.security.hpke.Kem;
import com.yahoo.security.hpke.LabeledKdfUtils;
import java.security.KeyPair;
import java.security.interfaces.XECPrivateKey;
import java.security.interfaces.XECPublicKey;
import java.util.function.Supplier;

final class DHKemX25519HkdfSha256
implements Kem {
    private static final HkdfSha256 HKDF = HkdfSha256.getInstance();
    private final Supplier<KeyPair> keyPairGen;
    private static final byte[] DHKEM_SUITE_ID_LABEL = new byte[]{75, 69, 77, 0, 32};

    DHKemX25519HkdfSha256(Supplier<KeyPair> keyPairGen) {
        this.keyPairGen = keyPairGen;
    }

    @Override
    public short nSecret() {
        return 32;
    }

    @Override
    public short nEnc() {
        return 32;
    }

    @Override
    public short nPk() {
        return 32;
    }

    @Override
    public short nSk() {
        return 32;
    }

    @Override
    public short kemId() {
        return 32;
    }

    private static byte[] serializePublicKey(XECPublicKey publicKey) {
        return KeyUtils.toRawX25519PublicKeyBytes(publicKey);
    }

    private static XECPublicKey deserializePublicKey(byte[] enc) {
        return KeyUtils.fromRawX25519PublicKey(enc);
    }

    private byte[] extractAndExpand(byte[] dh, byte[] kemContext) {
        byte[] eaePrk = LabeledKdfUtils.labeledExtractForSuite(HKDF, DHKEM_SUITE_ID_LABEL, Constants.EMPTY_LABEL, Constants.EAE_PRK_LABEL, dh);
        return LabeledKdfUtils.labeledExpandForSuite(HKDF, eaePrk, DHKEM_SUITE_ID_LABEL, Constants.SHARED_SECRET_LABEL, kemContext, this.nSecret());
    }

    @Override
    public Kem.EncapResult encap(XECPublicKey pkR) {
        KeyPair kpE = this.keyPairGen.get();
        XECPrivateKey skE = (XECPrivateKey)kpE.getPrivate();
        XECPublicKey pkE = (XECPublicKey)kpE.getPublic();
        byte[] dh = KeyUtils.ecdh(skE, pkR);
        byte[] enc = DHKemX25519HkdfSha256.serializePublicKey(pkE);
        byte[] pkRm = DHKemX25519HkdfSha256.serializePublicKey(pkR);
        byte[] kemContext = ArrayUtils.concat(enc, pkRm);
        byte[] sharedSecret = this.extractAndExpand(dh, kemContext);
        return new Kem.EncapResult(sharedSecret, enc);
    }

    @Override
    public Kem.EncapResult authEncap(XECPublicKey pkR, XECPrivateKey skS) {
        KeyPair kpE = this.keyPairGen.get();
        XECPrivateKey skE = (XECPrivateKey)kpE.getPrivate();
        XECPublicKey pkE = (XECPublicKey)kpE.getPublic();
        byte[] dh = ArrayUtils.concat(KeyUtils.ecdh(skE, pkR), KeyUtils.ecdh(skS, pkR));
        byte[] enc = DHKemX25519HkdfSha256.serializePublicKey(pkE);
        byte[] pkRm = DHKemX25519HkdfSha256.serializePublicKey(pkR);
        byte[] pkSm = DHKemX25519HkdfSha256.serializePublicKey(KeyUtils.extractX25519PublicKey(skS));
        byte[] kemContext = ArrayUtils.concat(enc, pkRm, pkSm);
        byte[] sharedSecret = this.extractAndExpand(dh, kemContext);
        return new Kem.EncapResult(sharedSecret, enc);
    }

    @Override
    public byte[] decap(byte[] enc, XECPrivateKey skR) {
        XECPublicKey pkE = DHKemX25519HkdfSha256.deserializePublicKey(enc);
        byte[] dh = KeyUtils.ecdh(skR, pkE);
        byte[] pkRm = DHKemX25519HkdfSha256.serializePublicKey(KeyUtils.extractX25519PublicKey(skR));
        byte[] kemContext = ArrayUtils.concat(enc, pkRm);
        return this.extractAndExpand(dh, kemContext);
    }

    @Override
    public byte[] authDecap(byte[] enc, XECPrivateKey skR, XECPublicKey pkS) {
        XECPublicKey pkE = DHKemX25519HkdfSha256.deserializePublicKey(enc);
        byte[] dh = ArrayUtils.concat(KeyUtils.ecdh(skR, pkE), KeyUtils.ecdh(skR, pkS));
        byte[] pkRm = DHKemX25519HkdfSha256.serializePublicKey(KeyUtils.extractX25519PublicKey(skR));
        byte[] pkSm = DHKemX25519HkdfSha256.serializePublicKey(pkS);
        byte[] kemContext = ArrayUtils.concat(enc, pkRm, pkSm);
        return this.extractAndExpand(dh, kemContext);
    }
}

