/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.hpke;

import com.yahoo.security.hpke.Aead;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

final class Aes128Gcm
implements Aead {
    private static final String AEAD_CIPHER_SPEC = "AES/GCM/NoPadding";
    private static final Aes128Gcm INSTANCE = new Aes128Gcm();

    Aes128Gcm() {
    }

    public static Aes128Gcm getInstance() {
        return INSTANCE;
    }

    private byte[] aeadImpl(int cipherMode, byte[] key, byte[] nonce, byte[] aad, byte[] text) {
        try {
            Cipher cipher = Cipher.getInstance(AEAD_CIPHER_SPEC);
            GCMParameterSpec gcmSpec = new GCMParameterSpec(this.nT() * 8, nonce);
            SecretKeySpec aesKey = new SecretKeySpec(key, "AES");
            cipher.init(cipherMode, (Key)aesKey, gcmSpec);
            cipher.updateAAD(aad);
            return cipher.doFinal(text);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] seal(byte[] key, byte[] nonce, byte[] aad, byte[] pt) {
        return this.aeadImpl(1, key, nonce, aad, pt);
    }

    @Override
    public byte[] open(byte[] key, byte[] nonce, byte[] aad, byte[] ct) {
        return this.aeadImpl(2, key, nonce, aad, ct);
    }

    @Override
    public short nK() {
        return 16;
    }

    @Override
    public short nN() {
        return 12;
    }

    @Override
    public short nT() {
        return 16;
    }

    @Override
    public short aeadId() {
        return 1;
    }
}

