/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import com.yahoo.security.tls.KeyManagerUtils;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.WeakHashMap;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

public class MutableX509KeyManager
extends X509ExtendedKeyManager {
    private final WeakHashMap<Thread, X509ExtendedKeyManager> threadLocalManager = new WeakHashMap();
    private volatile X509ExtendedKeyManager currentManager;

    public MutableX509KeyManager(KeyStore keystore, char[] password) {
        this.currentManager = KeyManagerUtils.createDefaultX509KeyManager(keystore, password);
    }

    public MutableX509KeyManager() {
        this.currentManager = KeyManagerUtils.createDefaultX509KeyManager();
    }

    public void updateKeystore(KeyStore keystore, char[] password) {
        this.currentManager = KeyManagerUtils.createDefaultX509KeyManager(keystore, password);
    }

    public void useDefaultKeystore() {
        this.currentManager = KeyManagerUtils.createDefaultX509KeyManager();
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.updateAndGetThreadLocalManager().getServerAliases(keyType, issuers);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.updateAndGetThreadLocalManager().getClientAliases(keyType, issuers);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.updateAndGetThreadLocalManager().chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.updateAndGetThreadLocalManager().chooseClientAlias(keyType, issuers, socket);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.updateAndGetThreadLocalManager().chooseEngineServerAlias(keyType, issuers, engine);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.updateAndGetThreadLocalManager().chooseEngineClientAlias(keyType, issuers, engine);
    }

    private X509ExtendedKeyManager updateAndGetThreadLocalManager() {
        X509ExtendedKeyManager currentManager = this.currentManager;
        this.threadLocalManager.put(Thread.currentThread(), currentManager);
        return currentManager;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        if (alias == null) {
            return null;
        }
        return this.getThreadLocalManager().getCertificateChain(alias);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        if (alias == null) {
            return null;
        }
        return this.getThreadLocalManager().getPrivateKey(alias);
    }

    private X509ExtendedKeyManager getThreadLocalManager() {
        X509ExtendedKeyManager manager = this.threadLocalManager.get(Thread.currentThread());
        if (manager == null) {
            throw new IllegalStateException("Methods to retrieve valid aliases has not been called previously from this thread");
        }
        return manager;
    }
}

