/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import com.yahoo.security.BouncyCastleProviderHolder;
import com.yahoo.security.SignatureAlgorithm;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;

public class SignatureUtils {
    public static Signature createSigner(PrivateKey key, SignatureAlgorithm algorithm) {
        try {
            Signature signer = Signature.getInstance(algorithm.getAlgorithmName(), (Provider)BouncyCastleProviderHolder.getInstance());
            signer.initSign(key);
            return signer;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Signature createVerifier(PublicKey key, SignatureAlgorithm algorithm) {
        try {
            Signature signer = Signature.getInstance(algorithm.getAlgorithmName(), (Provider)BouncyCastleProviderHolder.getInstance());
            signer.initVerify(key);
            return signer;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }
}

