/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls.policy;

import com.yahoo.security.tls.policy.RequiredPeerCredential;
import com.yahoo.security.tls.policy.Role;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PeerPolicy {
    private final String policyName;
    private final String description;
    private final Set<Role> assumedRoles;
    private final List<RequiredPeerCredential> requiredCredentials;

    public PeerPolicy(String policyName, Set<Role> assumedRoles, List<RequiredPeerCredential> requiredCredentials) {
        this(policyName, null, assumedRoles, requiredCredentials);
    }

    public PeerPolicy(String policyName, String description, Set<Role> assumedRoles, List<RequiredPeerCredential> requiredCredentials) {
        this.policyName = policyName;
        this.description = description;
        this.assumedRoles = assumedRoles;
        this.requiredCredentials = Collections.unmodifiableList(requiredCredentials);
    }

    public String policyName() {
        return this.policyName;
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public Set<Role> assumedRoles() {
        return this.assumedRoles;
    }

    public List<RequiredPeerCredential> requiredCredentials() {
        return this.requiredCredentials;
    }

    public String toString() {
        return "PeerPolicy{policyName='" + this.policyName + '\'' + ", description='" + this.description + '\'' + ", assumedRoles=" + this.assumedRoles + ", requiredCredentials=" + this.requiredCredentials + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeerPolicy that = (PeerPolicy)o;
        return Objects.equals(this.policyName, that.policyName) && Objects.equals(this.description, that.description) && Objects.equals(this.assumedRoles, that.assumedRoles) && Objects.equals(this.requiredCredentials, that.requiredCredentials);
    }

    public int hashCode() {
        return Objects.hash(this.policyName, this.description, this.assumedRoles, this.requiredCredentials);
    }
}

