/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls.https;

import com.yahoo.security.tls.MixedMode;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.security.tls.TransportSecurityUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;

public class VespaHttpClientBuilder {
    private static final Logger log = Logger.getLogger(VespaHttpClientBuilder.class.getName());

    private VespaHttpClientBuilder() {
    }

    public static HttpClientBuilder create() {
        return VespaHttpClientBuilder.createBuilder(null);
    }

    public static HttpClientBuilder create(ConnectionManagerFactory connectionManagerFactory) {
        return VespaHttpClientBuilder.createBuilder(connectionManagerFactory);
    }

    private static HttpClientBuilder createBuilder(ConnectionManagerFactory connectionManagerFactory) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        VespaHttpClientBuilder.addSslSocketFactory(builder, connectionManagerFactory);
        VespaHttpClientBuilder.addTlsAwareRequestInterceptor(builder);
        return builder;
    }

    private static void addSslSocketFactory(HttpClientBuilder builder, ConnectionManagerFactory connectionManagerFactory) {
        TransportSecurityUtils.createTlsContext().ifPresent(tlsContext -> {
            log.log(Level.FINE, "Adding ssl socket factory to client");
            SSLConnectionSocketFactory socketFactory = VespaHttpClientBuilder.createSslSocketFactory(tlsContext);
            if (connectionManagerFactory != null) {
                builder.setConnectionManager(connectionManagerFactory.create(socketFactory));
            } else {
                builder.setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
            }
        });
    }

    private static void addTlsAwareRequestInterceptor(HttpClientBuilder builder) {
        if (TransportSecurityUtils.isTransportSecurityEnabled() && TransportSecurityUtils.getInsecureMixedMode() != MixedMode.PLAINTEXT_CLIENT_MIXED_SERVER) {
            log.log(Level.FINE, "Adding request interceptor to client");
            builder.addInterceptorFirst((HttpRequestInterceptor)new HttpToHttpsRewritingRequestInterceptor());
        }
    }

    private static SSLConnectionSocketFactory createSslSocketFactory(TlsContext tlsContext) {
        SSLParameters parameters = tlsContext.parameters();
        return new SSLConnectionSocketFactory(tlsContext.context(), parameters.getProtocols(), parameters.getCipherSuites(), (HostnameVerifier)new NoopHostnameVerifier());
    }

    static class HttpToHttpsRewritingRequestInterceptor
    implements HttpRequestInterceptor {
        HttpToHttpsRewritingRequestInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) {
            if (request instanceof HttpRequestBase) {
                HttpRequestBase httpUriRequest = (HttpRequestBase)request;
                httpUriRequest.setURI(HttpToHttpsRewritingRequestInterceptor.rewriteUri(httpUriRequest.getURI()));
            } else {
                log.log(Level.FINE, () -> "Not a HttpRequestBase - skipping URI rewriting: " + request.getClass().getName());
            }
        }

        private static URI rewriteUri(URI originalUri) {
            if (!originalUri.getScheme().equals("http")) {
                return originalUri;
            }
            int port = originalUri.getPort();
            int rewrittenPort = port != -1 ? port : 80;
            try {
                URI rewrittenUri = new URIBuilder(originalUri).setScheme("https").setPort(rewrittenPort).build();
                log.log(Level.FINE, () -> String.format("Uri rewritten from '%s' to '%s'", originalUri, rewrittenUri));
                return rewrittenUri;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface ConnectionManagerFactory {
        public HttpClientConnectionManager create(SSLConnectionSocketFactory var1);
    }
}

