/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls.https;

import com.yahoo.security.tls.TlsContext;
import com.yahoo.security.tls.https.TlsAwareHttpClient;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

public class TlsAwareHttpClientBuilder
implements HttpClient.Builder {
    private final HttpClient.Builder wrappedBuilder;
    private final String userAgent;

    public TlsAwareHttpClientBuilder(String userAgent) {
        this(null, userAgent);
    }

    public TlsAwareHttpClientBuilder(TlsContext tlsContext, String userAgent) {
        this.wrappedBuilder = tlsContext != null ? HttpClient.newBuilder().sslContext(tlsContext.context()).sslParameters(tlsContext.parameters()) : HttpClient.newBuilder();
        this.userAgent = userAgent;
    }

    @Override
    public HttpClient.Builder cookieHandler(CookieHandler cookieHandler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpClient.Builder connectTimeout(Duration duration) {
        this.wrappedBuilder.connectTimeout(duration);
        return this;
    }

    @Override
    public HttpClient.Builder sslContext(SSLContext sslContext) {
        throw new UnsupportedOperationException("SSLContext is given from tls context");
    }

    @Override
    public HttpClient.Builder sslParameters(SSLParameters sslParameters) {
        throw new UnsupportedOperationException("SSLParameters is given from tls context");
    }

    @Override
    public HttpClient.Builder executor(Executor executor) {
        this.wrappedBuilder.executor(executor);
        return this;
    }

    @Override
    public HttpClient.Builder followRedirects(HttpClient.Redirect policy) {
        this.wrappedBuilder.followRedirects(policy);
        return this;
    }

    @Override
    public HttpClient.Builder version(HttpClient.Version version) {
        this.wrappedBuilder.version(version);
        return this;
    }

    @Override
    public HttpClient.Builder priority(int priority) {
        this.wrappedBuilder.priority(priority);
        return this;
    }

    @Override
    public HttpClient.Builder proxy(ProxySelector proxySelector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpClient.Builder authenticator(Authenticator authenticator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpClient build() {
        return new TlsAwareHttpClient(this.wrappedBuilder.build(), this.userAgent);
    }
}

