/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import com.yahoo.security.tls.json.TransportSecurityOptionsJsonSerializer;
import com.yahoo.security.tls.policy.AuthorizedPeers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TransportSecurityOptions {
    private final Path privateKeyFile;
    private final Path certificatesFile;
    private final Path caCertificatesFile;
    private final AuthorizedPeers authorizedPeers;
    private final List<String> acceptedCiphers;
    private final boolean isHostnameValidationDisabled;

    private TransportSecurityOptions(Builder builder) {
        this.privateKeyFile = builder.privateKeyFile;
        this.certificatesFile = builder.certificatesFile;
        this.caCertificatesFile = builder.caCertificatesFile;
        this.authorizedPeers = builder.authorizedPeers;
        this.acceptedCiphers = builder.acceptedCiphers;
        this.isHostnameValidationDisabled = builder.isHostnameValidationDisabled;
    }

    public Optional<Path> getPrivateKeyFile() {
        return Optional.ofNullable(this.privateKeyFile);
    }

    public Optional<Path> getCertificatesFile() {
        return Optional.ofNullable(this.certificatesFile);
    }

    public Optional<Path> getCaCertificatesFile() {
        return Optional.ofNullable(this.caCertificatesFile);
    }

    public Optional<AuthorizedPeers> getAuthorizedPeers() {
        return Optional.ofNullable(this.authorizedPeers);
    }

    public List<String> getAcceptedCiphers() {
        return this.acceptedCiphers;
    }

    public boolean isHostnameValidationDisabled() {
        return this.isHostnameValidationDisabled;
    }

    public static TransportSecurityOptions fromJsonFile(Path file) {
        TransportSecurityOptions transportSecurityOptions;
        block8: {
            InputStream in = Files.newInputStream(file, new OpenOption[0]);
            try {
                transportSecurityOptions = new TransportSecurityOptionsJsonSerializer().deserialize(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            in.close();
        }
        return transportSecurityOptions;
    }

    public static TransportSecurityOptions fromJson(String json) {
        return new TransportSecurityOptionsJsonSerializer().deserialize(new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)));
    }

    public String toJson() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new TransportSecurityOptionsJsonSerializer().serialize(out, this);
        return new String(out.toByteArray(), StandardCharsets.UTF_8);
    }

    public void toJsonFile(Path file) {
        try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
            new TransportSecurityOptionsJsonSerializer().serialize(out, this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return "TransportSecurityOptions{privateKeyFile=" + this.privateKeyFile + ", certificatesFile=" + this.certificatesFile + ", caCertificatesFile=" + this.caCertificatesFile + ", authorizedPeers=" + this.authorizedPeers + ", acceptedCiphers=" + this.acceptedCiphers + ", isHostnameValidationDisabled=" + this.isHostnameValidationDisabled + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransportSecurityOptions that = (TransportSecurityOptions)o;
        return this.isHostnameValidationDisabled == that.isHostnameValidationDisabled && Objects.equals(this.privateKeyFile, that.privateKeyFile) && Objects.equals(this.certificatesFile, that.certificatesFile) && Objects.equals(this.caCertificatesFile, that.caCertificatesFile) && Objects.equals(this.authorizedPeers, that.authorizedPeers) && Objects.equals(this.acceptedCiphers, that.acceptedCiphers);
    }

    public int hashCode() {
        return Objects.hash(this.privateKeyFile, this.certificatesFile, this.caCertificatesFile, this.authorizedPeers, this.acceptedCiphers, this.isHostnameValidationDisabled);
    }

    public static class Builder {
        private Path privateKeyFile;
        private Path certificatesFile;
        private Path caCertificatesFile;
        private AuthorizedPeers authorizedPeers;
        private List<String> acceptedCiphers = new ArrayList<String>();
        private boolean isHostnameValidationDisabled;

        public Builder withCertificates(Path certificatesFile, Path privateKeyFile) {
            this.certificatesFile = certificatesFile;
            this.privateKeyFile = privateKeyFile;
            return this;
        }

        public Builder withCaCertificates(Path caCertificatesFile) {
            this.caCertificatesFile = caCertificatesFile;
            return this;
        }

        public Builder withAuthorizedPeers(AuthorizedPeers authorizedPeers) {
            this.authorizedPeers = authorizedPeers;
            return this;
        }

        public Builder withAcceptedCiphers(List<String> acceptedCiphers) {
            this.acceptedCiphers = acceptedCiphers;
            return this;
        }

        public Builder withHostnameValidationDisabled(boolean isDisabled) {
            this.isHostnameValidationDisabled = isDisabled;
            return this;
        }

        public TransportSecurityOptions build() {
            return new TransportSecurityOptions(this);
        }
    }
}

