/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import com.yahoo.security.KeyStoreBuilder;
import com.yahoo.security.KeyStoreType;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.SslContextBuilder;
import com.yahoo.security.X509CertificateUtils;
import com.yahoo.security.tls.AuthorizationMode;
import com.yahoo.security.tls.DefaultTlsContext;
import com.yahoo.security.tls.MutableX509KeyManager;
import com.yahoo.security.tls.MutableX509TrustManager;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.security.tls.TransportSecurityOptions;
import com.yahoo.security.tls.authz.PeerAuthorizerTrustManager;
import com.yahoo.security.tls.policy.AuthorizedPeers;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class ReloadingTlsContext
implements TlsContext {
    private static final Duration UPDATE_PERIOD = Duration.ofHours(1L);
    private static final Logger log = Logger.getLogger(ReloadingTlsContext.class.getName());
    private final Path tlsOptionsConfigFile;
    private final TlsContext tlsContext;
    private final MutableX509TrustManager trustManager = new MutableX509TrustManager();
    private final MutableX509KeyManager keyManager = new MutableX509KeyManager();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(runnable -> {
        Thread thread = new Thread(runnable, "tls-context-reloader");
        thread.setDaemon(true);
        return thread;
    });

    public ReloadingTlsContext(Path tlsOptionsConfigFile, AuthorizationMode mode) {
        this.tlsOptionsConfigFile = tlsOptionsConfigFile;
        TransportSecurityOptions options = TransportSecurityOptions.fromJsonFile(tlsOptionsConfigFile);
        ReloadingTlsContext.reloadCryptoMaterial(options, this.trustManager, this.keyManager);
        this.tlsContext = ReloadingTlsContext.createDefaultTlsContext(options, mode, this.trustManager, this.keyManager);
        this.scheduler.scheduleAtFixedRate(new CryptoMaterialReloader(), UPDATE_PERIOD.getSeconds(), UPDATE_PERIOD.getSeconds(), TimeUnit.SECONDS);
    }

    private static void reloadCryptoMaterial(TransportSecurityOptions options, MutableX509TrustManager trustManager, MutableX509KeyManager keyManager) {
        if (options.getCaCertificatesFile().isPresent()) {
            trustManager.updateTruststore(ReloadingTlsContext.loadTruststore(options.getCaCertificatesFile().get()));
        } else {
            trustManager.useDefaultTruststore();
        }
        if (options.getPrivateKeyFile().isPresent() && options.getCertificatesFile().isPresent()) {
            keyManager.updateKeystore(ReloadingTlsContext.loadKeystore(options.getPrivateKeyFile().get(), options.getCertificatesFile().get()), new char[0]);
        } else {
            keyManager.useDefaultKeystore();
        }
    }

    private static KeyStore loadTruststore(Path caCertificateFile) {
        try {
            List<X509Certificate> caCertificates = X509CertificateUtils.certificateListFromPem(Files.readString(caCertificateFile));
            KeyStoreBuilder trustStoreBuilder = KeyStoreBuilder.withType(KeyStoreType.PKCS12);
            for (int i = 0; i < caCertificates.size(); ++i) {
                trustStoreBuilder.withCertificateEntry("cert-" + i, caCertificates.get(i));
            }
            return trustStoreBuilder.build();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static KeyStore loadKeystore(Path privateKeyFile, Path certificatesFile) {
        try {
            return KeyStoreBuilder.withType(KeyStoreType.PKCS12).withKeyEntry("default", KeyUtils.fromPemEncodedPrivateKey(Files.readString(privateKeyFile)), X509CertificateUtils.certificateListFromPem(Files.readString(certificatesFile))).build();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static DefaultTlsContext createDefaultTlsContext(TransportSecurityOptions options, AuthorizationMode mode, MutableX509TrustManager mutableTrustManager, MutableX509KeyManager mutableKeyManager) {
        SSLContext sslContext = new SslContextBuilder().withKeyManagerFactory((ignoredKeystore, ignoredPassword) -> mutableKeyManager).withTrustManagerFactory(ignoredTruststore -> options.getAuthorizedPeers().map(authorizedPeers -> new PeerAuthorizerTrustManager((AuthorizedPeers)authorizedPeers, mode, mutableTrustManager)).orElse(mutableTrustManager)).build();
        return new DefaultTlsContext(sslContext, options.getAcceptedCiphers());
    }

    @Override
    public SSLContext context() {
        return this.tlsContext.context();
    }

    @Override
    public SSLParameters parameters() {
        return this.tlsContext.parameters();
    }

    @Override
    public SSLEngine createSslEngine() {
        return this.tlsContext.createSslEngine();
    }

    @Override
    public SSLEngine createSslEngine(String peerHost, int peerPort) {
        return this.tlsContext.createSslEngine(peerHost, peerPort);
    }

    @Override
    public void close() {
        try {
            this.scheduler.shutdownNow();
            this.scheduler.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private class CryptoMaterialReloader
    implements Runnable {
        private CryptoMaterialReloader() {
        }

        @Override
        public void run() {
            try {
                ReloadingTlsContext.reloadCryptoMaterial(TransportSecurityOptions.fromJsonFile(ReloadingTlsContext.this.tlsOptionsConfigFile), ReloadingTlsContext.this.trustManager, ReloadingTlsContext.this.keyManager);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, String.format("Failed to reload crypto material (path='%s'): %s", ReloadingTlsContext.this.tlsOptionsConfigFile, t.getMessage()), t);
            }
        }
    }
}

