/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls.policy;

import java.util.Objects;
import java.util.regex.Pattern;

public class HostGlobPattern {
    private final String pattern;
    private final Pattern regexPattern;

    public HostGlobPattern(String pattern) {
        this.pattern = pattern;
        this.regexPattern = HostGlobPattern.toRegexPattern(pattern);
    }

    public String asString() {
        return this.pattern;
    }

    public boolean matches(String hostString) {
        return this.regexPattern.matcher(hostString).matches();
    }

    private static Pattern toRegexPattern(String pattern) {
        StringBuilder builder = new StringBuilder("^");
        for (char c : pattern.toCharArray()) {
            if (c == '*') {
                builder.append("[^.]*");
                continue;
            }
            if (c == '?') {
                builder.append("[^.]");
                continue;
            }
            if (HostGlobPattern.isRegexMetaCharacter(c)) {
                builder.append("\\");
                builder.append(c);
                continue;
            }
            builder.append(c);
        }
        builder.append('$');
        return Pattern.compile(builder.toString());
    }

    private static boolean isRegexMetaCharacter(char c) {
        return "<([{\\^-=$!|]})?*+.>".indexOf(c) != -1;
    }

    public String toString() {
        return "HostGlobPattern{pattern='" + this.pattern + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostGlobPattern that = (HostGlobPattern)o;
        return Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.pattern);
    }
}

