/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import com.yahoo.security.KeyStoreBuilder;
import com.yahoo.security.KeyStoreType;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.X509CertificateUtils;
import com.yahoo.security.tls.KeyManagerUtils;
import com.yahoo.security.tls.TrustManagerUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;

public class SslContextBuilder {
    private KeyStoreSupplier trustStoreSupplier = () -> null;
    private KeyStoreSupplier keyStoreSupplier = () -> null;
    private char[] keyStorePassword;
    private TrustManagerFactory trustManagerFactory = TrustManagerUtils::createDefaultX509TrustManager;
    private KeyManagerFactory keyManagerFactory = KeyManagerUtils::createDefaultX509KeyManager;
    private X509ExtendedKeyManager keyManager;

    public SslContextBuilder withTrustStore(Path file, KeyStoreType trustStoreType) {
        this.trustStoreSupplier = () -> KeyStoreBuilder.withType(trustStoreType).fromFile(file).build();
        return this;
    }

    public SslContextBuilder withTrustStore(KeyStore trustStore) {
        this.trustStoreSupplier = () -> trustStore;
        return this;
    }

    public SslContextBuilder withTrustStore(X509Certificate caCertificate) {
        return this.withTrustStore(Collections.singletonList(caCertificate));
    }

    public SslContextBuilder withTrustStore(List<X509Certificate> caCertificates) {
        this.trustStoreSupplier = () -> SslContextBuilder.createTrustStore(caCertificates);
        return this;
    }

    public SslContextBuilder withTrustStore(Path pemEncodedCaCertificates) {
        this.trustStoreSupplier = () -> {
            List<X509Certificate> caCertificates = X509CertificateUtils.certificateListFromPem(new String(Files.readAllBytes(pemEncodedCaCertificates)));
            return SslContextBuilder.createTrustStore(caCertificates);
        };
        return this;
    }

    public SslContextBuilder withKeyStore(PrivateKey privateKey, X509Certificate certificate) {
        return this.withKeyStore(privateKey, Collections.singletonList(certificate));
    }

    public SslContextBuilder withKeyStore(PrivateKey privateKey, List<X509Certificate> certificates) {
        char[] pwd = new char[]{};
        this.keyStoreSupplier = () -> KeyStoreBuilder.withType(KeyStoreType.JKS).withKeyEntry("default", privateKey, certificates).build();
        this.keyStorePassword = pwd;
        return this;
    }

    public SslContextBuilder withKeyStore(KeyStore keyStore, char[] password) {
        this.keyStoreSupplier = () -> keyStore;
        this.keyStorePassword = password;
        return this;
    }

    public SslContextBuilder withKeyStore(Path file, char[] password, KeyStoreType keyStoreType) {
        this.keyStoreSupplier = () -> KeyStoreBuilder.withType(keyStoreType).fromFile(file, password).build();
        this.keyStorePassword = password;
        return this;
    }

    public SslContextBuilder withKeyStore(Path privateKeyPemFile, Path certificatesPemFile) {
        this.keyStoreSupplier = () -> {
            PrivateKey privateKey = KeyUtils.fromPemEncodedPrivateKey(new String(Files.readAllBytes(privateKeyPemFile)));
            List<X509Certificate> certificates = X509CertificateUtils.certificateListFromPem(new String(Files.readAllBytes(certificatesPemFile)));
            return KeyStoreBuilder.withType(KeyStoreType.JKS).withKeyEntry("default", privateKey, certificates).build();
        };
        this.keyStorePassword = new char[0];
        return this;
    }

    public SslContextBuilder withTrustManagerFactory(TrustManagerFactory trustManagersFactory) {
        this.trustManagerFactory = trustManagersFactory;
        return this;
    }

    public SslContextBuilder withKeyManagerFactory(KeyManagerFactory keyManagerFactory) {
        this.keyManagerFactory = keyManagerFactory;
        return this;
    }

    public SslContextBuilder withKeyManager(X509ExtendedKeyManager keyManager) {
        this.keyManager = keyManager;
        return this;
    }

    public SSLContext build() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            TrustManager[] trustManagers = new TrustManager[]{this.trustManagerFactory.createTrustManager(this.trustStoreSupplier.get())};
            X509ExtendedKeyManager keyManager = this.keyManager != null ? this.keyManager : this.keyManagerFactory.createKeyManager(this.keyStoreSupplier.get(), this.keyStorePassword);
            KeyManager[] keyManagers = new KeyManager[]{keyManager};
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static KeyStore createTrustStore(List<X509Certificate> caCertificates) {
        return KeyStoreBuilder.withType(KeyStoreType.JKS).withCertificateEntries("cert", caCertificates).build();
    }

    @FunctionalInterface
    public static interface KeyManagerFactory {
        public X509ExtendedKeyManager createKeyManager(KeyStore var1, char[] var2) throws GeneralSecurityException;
    }

    @FunctionalInterface
    public static interface TrustManagerFactory {
        public X509ExtendedTrustManager createTrustManager(KeyStore var1) throws GeneralSecurityException;
    }

    private static interface KeyStoreSupplier {
        public KeyStore get() throws IOException, GeneralSecurityException;
    }
}

