/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.ArithmeticNode;
import com.yahoo.searchlib.rankingexpression.rule.ArithmeticOperator;
import com.yahoo.searchlib.rankingexpression.rule.ComparisonNode;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.EmbracedNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.GeneratorLambdaFunctionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.rule.TruthOperator;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.Generate;
import com.yahoo.tensor.functions.Join;
import com.yahoo.tensor.functions.Reduce;
import com.yahoo.tensor.functions.Rename;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.TensorFunction;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Reshape
extends IntermediateOperation {
    private final IntermediateOperation.AttributeMap attributeMap;

    public Reshape(String modelName, String nodeName, List<IntermediateOperation> inputs, IntermediateOperation.AttributeMap attributeMap) {
        super(modelName, nodeName, inputs);
        this.attributeMap = attributeMap;
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        if (this.inputs.size() == 2) {
            return this.typeWithShapeAsInput();
        }
        if (this.inputs.size() == 1) {
            return this.typeWithShapeAsAttribute();
        }
        throw new IllegalArgumentException("Expected 2 or 3 inputs for '" + this.name + "', got " + this.inputs.size());
    }

    private OrderedTensorType typeWithShapeAsInput() {
        int i;
        IntermediateOperation newShape = (IntermediateOperation)this.inputs.get(1);
        if (newShape.getConstantValue().isEmpty()) {
            throw new IllegalArgumentException("Reshape " + this.name + ": Shape input must be a constant.");
        }
        OrderedTensorType inputType = ((IntermediateOperation)this.inputs.get(0)).type().get();
        Tensor shape = newShape.getConstantValue().get().asTensor();
        ArrayList<Integer> dimSizes = new ArrayList<Integer>(shape.type().rank());
        shape.valueIterator().forEachRemaining(v -> dimSizes.add(v.intValue()));
        for (i = 0; i < dimSizes.size(); ++i) {
            if ((Integer)dimSizes.get(i) != 0) continue;
            if (i >= inputType.dimensions().size()) {
                throw new IllegalArgumentException("Reshape " + this.name + ": 0 value for dimension not found in input");
            }
            dimSizes.set(i, ((Long)inputType.dimensions().get(i).size().get()).intValue());
        }
        for (i = 0; i < dimSizes.size(); ++i) {
            if ((Integer)dimSizes.get(i) >= 0) continue;
            int shapeSize = dimSizes.stream().reduce(1, (a, b) -> a * b);
            int tensorSize = OrderedTensorType.tensorSize(inputType.type()).intValue();
            dimSizes.set(i, -1 * tensorSize / (shapeSize == 0 ? -1 : shapeSize));
        }
        return this.buildOutputType(dimSizes);
    }

    private OrderedTensorType typeWithShapeAsAttribute() {
        if (this.attributeMap.getList("shape").isEmpty() || this.attributeMap.getList("shape").get().size() == 0) {
            throw new IllegalArgumentException("Reshape in " + this.name + ": Shape attribute is empty.");
        }
        OrderedTensorType inputType = ((IntermediateOperation)this.inputs.get(0)).type().get();
        List<Value> shape = this.attributeMap.getList("shape").get();
        ArrayList<Integer> dimSizes = new ArrayList<Integer>(shape.size());
        for (Value v : shape) {
            int size = (int)v.asDouble();
            if (size < 0) {
                int shapeSize = (int)shape.stream().mapToDouble(Value::asDouble).reduce(1.0, (a, b) -> a * b);
                int tensorSize = OrderedTensorType.tensorSize(inputType.type()).intValue();
                size = -1 * shapeSize / tensorSize;
            }
            dimSizes.add(size);
        }
        return this.buildOutputType(dimSizes);
    }

    private OrderedTensorType buildOutputType(List<Integer> dimSizes) {
        OrderedTensorType.Builder outputTypeBuilder = new OrderedTensorType.Builder(this.resultValueType());
        for (int i = 0; i < dimSizes.size(); ++i) {
            outputTypeBuilder.add(TensorType.Dimension.indexed((String)String.format("%s_%d", this.vespaName(), i), (long)dimSizes.get(i).intValue()));
        }
        return outputTypeBuilder.build();
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        if (!this.inputs.stream().map(IntermediateOperation::type).allMatch(Optional::isPresent)) {
            return null;
        }
        if (!this.inputs.stream().map(IntermediateOperation::function).allMatch(Optional::isPresent)) {
            return null;
        }
        OrderedTensorType inputType = ((IntermediateOperation)this.inputs.get(0)).type().get();
        TensorFunction inputFunction = ((IntermediateOperation)this.inputs.get(0)).function().get();
        return Reshape.reshape(inputFunction, inputType, this.type);
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        this.addConstraintsFrom(this.type, renamer);
    }

    @Override
    public Reshape withInputs(List<IntermediateOperation> inputs) {
        return new Reshape(this.modelName(), this.name(), inputs, this.attributeMap);
    }

    public static TensorFunction reshape(TensorFunction inputFunction, OrderedTensorType inputType, OrderedTensorType outputType) {
        if (!OrderedTensorType.tensorSize(inputType.type()).equals(OrderedTensorType.tensorSize(outputType.type()))) {
            throw new IllegalArgumentException("New and old shape of tensor must have the same size when reshaping");
        }
        ArrayList<String> from = new ArrayList<String>();
        ArrayList<CallSite> to = new ArrayList<CallSite>();
        boolean dimensionNamesOverlap = Reshape.dimensionNamesOverlap(inputType, outputType);
        if (dimensionNamesOverlap) {
            OrderedTensorType.Builder builder = new OrderedTensorType.Builder(outputType.type().valueType());
            for (int i = 0; i < outputType.rank(); ++i) {
                TensorType.Dimension dim = outputType.dimensions().get(i);
                from.add(dim.name());
                to.add((CallSite)((Object)("temp_" + dim.name())));
                builder.add(dim.withName("temp_" + dim.name()));
            }
            outputType = builder.build();
        }
        ExpressionNode unrollFrom = Reshape.unrollTensorExpression(inputType);
        ExpressionNode unrollTo = Reshape.unrollTensorExpression(outputType);
        ComparisonNode transformExpression = new ComparisonNode((ExpressionNode)new EmbracedNode(unrollFrom), TruthOperator.EQUAL, (ExpressionNode)new EmbracedNode(unrollTo));
        TensorType transformationType = new TensorType.Builder(new TensorType[]{inputType.type(), outputType.type()}).build();
        Generate transformTensor = new Generate(transformationType, (Function)new GeneratorLambdaFunctionNode(transformationType, (ExpressionNode)transformExpression).asLongListToDoubleOperator());
        Reduce result = new Reduce((TensorFunction)new Join(inputFunction, (TensorFunction)transformTensor, ScalarFunctions.multiply()), Reduce.Aggregator.sum, inputType.dimensions().stream().map(TensorType.Dimension::name).collect(Collectors.toList()));
        if (dimensionNamesOverlap) {
            result = new Rename((TensorFunction)result, to, from);
        }
        return result;
    }

    private static boolean dimensionNamesOverlap(OrderedTensorType a, OrderedTensorType b) {
        return a.dimensionNames().stream().anyMatch(d -> b.type().indexOfDimension(d).isPresent());
    }

    private static ExpressionNode unrollTensorExpression(OrderedTensorType type) {
        if (type.rank() == 0) {
            return new ConstantNode((Value)DoubleValue.zero);
        }
        ArrayList<Object> children = new ArrayList<Object>();
        ArrayList<ArithmeticOperator> operators = new ArrayList<ArithmeticOperator>();
        int size = 1;
        for (int i = type.dimensions().size() - 1; i >= 0; --i) {
            TensorType.Dimension dimension = type.dimensions().get(i);
            children.add(0, new ReferenceNode(dimension.name()));
            if (size > 1) {
                operators.add(0, ArithmeticOperator.MULTIPLY);
                children.add(0, new ConstantNode((Value)new DoubleValue((double)size)));
            }
            size = (int)((long)size * OrderedTensorType.dimensionSize(dimension));
            if (i <= 0) continue;
            operators.add(0, ArithmeticOperator.PLUS);
        }
        return new ArithmeticNode(children, operators);
    }

    @Override
    public String operationName() {
        return "Reshape";
    }
}

