/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.api;

import ai.vespa.hosted.api.Method;
import ai.vespa.hosted.api.Signatures;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.SignatureAlgorithm;
import com.yahoo.security.SignatureUtils;
import java.net.URI;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;

public class RequestVerifier {
    private final Signature verifier;
    private final Clock clock;

    public RequestVerifier(String pemPublicKey) {
        this(pemPublicKey, Clock.systemUTC());
    }

    public RequestVerifier(String pemPublicKey, Clock clock) {
        this.verifier = SignatureUtils.createVerifier((PublicKey)KeyUtils.fromPemEncodedPublicKey((String)pemPublicKey), (SignatureAlgorithm)SignatureAlgorithm.SHA256_WITH_ECDSA);
        this.clock = clock;
    }

    public boolean verify(Method method, URI requestUri, String timestamp, String contentHash, String signature) {
        try {
            Instant now = this.clock.instant();
            Instant then = Instant.parse(timestamp);
            if (Duration.between(now, then).abs().compareTo(Duration.ofMinutes(5L)) > 0) {
                return false;
            }
            byte[] canonicalMessage = Signatures.canonicalMessageOf(method.name(), requestUri, timestamp, contentHash);
            this.verifier.update(canonicalMessage);
            return this.verifier.verify(Base64.getDecoder().decode(signature));
        }
        catch (RuntimeException | SignatureException e) {
            return false;
        }
    }
}

