/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.api;

import ai.vespa.hosted.api.Deployment;
import ai.vespa.hosted.api.DeploymentLog;
import ai.vespa.hosted.api.DeploymentResult;
import ai.vespa.hosted.api.Method;
import ai.vespa.hosted.api.MultiPartStreamer;
import ai.vespa.hosted.api.RequestSigner;
import ai.vespa.hosted.api.Submission;
import ai.vespa.hosted.api.TestConfig;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationName;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.zone.ZoneId;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.SslContextBuilder;
import com.yahoo.security.X509CertificateUtils;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.JsonDecoder;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.OptionalLong;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class ControllerHttpClient {
    private final HttpClient client;
    private final URI endpoint;

    protected ControllerHttpClient(URI endpoint, HttpClient.Builder client) {
        this.endpoint = endpoint.resolve("/");
        this.client = client.connectTimeout(Duration.ofSeconds(5L)).version(HttpClient.Version.HTTP_1_1).build();
    }

    public static ControllerHttpClient withSignatureKey(URI endpoint, String privateKey, ApplicationId id) {
        return new SigningControllerHttpClient(endpoint, privateKey, id);
    }

    public static ControllerHttpClient withSignatureKey(URI endpoint, Path privateKeyFile, ApplicationId id) {
        return new SigningControllerHttpClient(endpoint, privateKeyFile, id);
    }

    public static ControllerHttpClient withKeyAndCertificate(URI endpoint, String privateKey, String certificate) {
        return new MutualTlsControllerHttpClient(endpoint, privateKey, certificate);
    }

    public static ControllerHttpClient withKeyAndCertificate(URI endpoint, Path privateKeyFile, Path certificateFile) {
        return new MutualTlsControllerHttpClient(endpoint, privateKeyFile, certificateFile);
    }

    public String submit(Submission submission, TenantName tenant, ApplicationName application) {
        return ControllerHttpClient.toMessage(this.send(this.request(HttpRequest.newBuilder(this.applicationPath(tenant, application).resolve("submit")).timeout(Duration.ofMinutes(30L)), Method.POST, new MultiPartStreamer().addJson("submitOptions", ControllerHttpClient.metaToJson(submission)).addFile("applicationZip", submission.applicationZip()).addFile("applicationTestZip", submission.applicationTestZip()))));
    }

    public DeploymentResult deploy(Deployment deployment, ApplicationId id, ZoneId zone) {
        return ControllerHttpClient.toDeploymentResult(this.send(this.request(HttpRequest.newBuilder(this.deploymentJobPath(id, zone)).timeout(Duration.ofMinutes(60L)), Method.POST, ControllerHttpClient.toDataStream(deployment))));
    }

    public String deactivate(ApplicationId id, ZoneId zone) {
        return ControllerHttpClient.asString(this.send(this.request(HttpRequest.newBuilder(this.deploymentPath(id, zone)).timeout(Duration.ofSeconds(10L)), Method.DELETE)));
    }

    public ZoneId defaultZone(Environment environment) {
        Inspector rootObject = ControllerHttpClient.toInspector(this.send(this.request(HttpRequest.newBuilder(this.defaultRegionPath(environment)).timeout(Duration.ofSeconds(10L)), Method.GET)));
        return ZoneId.from((String)"dev", (String)rootObject.field("name").asString());
    }

    public String compileVersion(ApplicationId id) {
        return ControllerHttpClient.toInspector(this.send(this.request(HttpRequest.newBuilder(this.applicationPath(id.tenant(), id.application())).timeout(Duration.ofSeconds(10L)), Method.GET))).field("compileVersion").asString();
    }

    public TestConfig testConfig(ApplicationId id, ZoneId zone) {
        return TestConfig.fromJson(ControllerHttpClient.asBytes(this.send(this.request(HttpRequest.newBuilder(this.testConfigPath(id, zone)), Method.GET))));
    }

    public DeploymentLog deploymentLog(ApplicationId id, ZoneId zone, long run, long after) {
        return ControllerHttpClient.toDeploymentLog(this.send(this.request(HttpRequest.newBuilder(this.runPath(id, zone, run, after)).timeout(Duration.ofSeconds(10L)), Method.GET)));
    }

    public DeploymentLog deploymentLog(ApplicationId id, ZoneId zone, long run) {
        return this.deploymentLog(id, zone, run, -1L);
    }

    protected HttpRequest request(HttpRequest.Builder request, Method method, Supplier<InputStream> data) {
        return request.method(method.name(), HttpRequest.BodyPublishers.ofInputStream(data)).build();
    }

    private HttpRequest request(HttpRequest.Builder request, Method method) {
        return this.request(request, method, InputStream::nullInputStream);
    }

    private HttpRequest request(HttpRequest.Builder request, Method method, byte[] data) {
        return this.request(request, method, () -> new ByteArrayInputStream(data));
    }

    private HttpRequest request(HttpRequest.Builder request, Method method, MultiPartStreamer data) {
        return this.request(request.setHeader("Content-Type", data.contentType()), method, data::data);
    }

    private URI applicationApiPath() {
        return ControllerHttpClient.concatenated(this.endpoint, "application", "v4");
    }

    private URI tenantPath(TenantName tenant) {
        return ControllerHttpClient.concatenated(this.applicationApiPath(), "tenant", tenant.value());
    }

    private URI applicationPath(TenantName tenant, ApplicationName application) {
        return ControllerHttpClient.concatenated(this.tenantPath(tenant), "application", application.value());
    }

    private URI instancePath(ApplicationId id) {
        return ControllerHttpClient.concatenated(this.applicationPath(id.tenant(), id.application()), "instance", id.instance().value());
    }

    private URI deploymentPath(ApplicationId id, ZoneId zone) {
        return ControllerHttpClient.concatenated(this.applicationPath(id.tenant(), id.application()), "environment", zone.environment().value(), "region", zone.region().value(), "instance", id.instance().value());
    }

    private URI deploymentJobPath(ApplicationId id, ZoneId zone) {
        return ControllerHttpClient.concatenated(this.instancePath(id), "deploy", ControllerHttpClient.jobNameOf(zone));
    }

    private URI jobPath(ApplicationId id, ZoneId zone) {
        return ControllerHttpClient.concatenated(this.instancePath(id), "job", ControllerHttpClient.jobNameOf(zone));
    }

    private URI testConfigPath(ApplicationId id, ZoneId zone) {
        return ControllerHttpClient.concatenated(this.jobPath(id, zone), "test-config");
    }

    private URI runPath(ApplicationId id, ZoneId zone, long run, long after) {
        return ControllerHttpClient.withQuery(ControllerHttpClient.concatenated(this.jobPath(id, zone), "run", Long.toString(run)), "after", Long.toString(after));
    }

    private URI defaultRegionPath(Environment environment) {
        return ControllerHttpClient.concatenated(this.endpoint, "zone", "v1", "environment", environment.value(), "default");
    }

    private static URI concatenated(URI base, String ... parts) {
        return base.resolve(Stream.of(parts).map(part -> URLEncoder.encode(part, StandardCharsets.UTF_8)).collect(Collectors.joining("/")) + "/");
    }

    private static URI withQuery(URI base, String name, String value) {
        return base.resolve("?" + (String)(base.getRawQuery() != null ? base.getRawQuery() + "&" : "") + URLEncoder.encode(name, StandardCharsets.UTF_8) + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8));
    }

    private static String jobNameOf(ZoneId zone) {
        return zone.environment().value() + "-" + zone.region().value();
    }

    private HttpResponse<byte[]> send(HttpRequest request) {
        return ControllerHttpClient.unchecked(() -> this.client.send(request, HttpResponse.BodyHandlers.ofByteArray()));
    }

    private static <T> T unchecked(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String metaToJson(Deployment deployment) {
        Slime slime = new Slime();
        Cursor rootObject = slime.setObject();
        deployment.version().ifPresent(version -> rootObject.setString("vespaVersion", version));
        rootObject.setBool("deployDirectly", true);
        return ControllerHttpClient.toJson(slime);
    }

    private static String metaToJson(Submission submission) {
        Slime slime = new Slime();
        Cursor rootObject = slime.setObject();
        rootObject.setString("repository", submission.repository());
        rootObject.setString("branch", submission.branch());
        rootObject.setString("commit", submission.commit());
        rootObject.setString("authorEmail", submission.authorEmail());
        submission.projectId().ifPresent(projectId -> rootObject.setLong("projectId", projectId));
        return ControllerHttpClient.toJson(slime);
    }

    private static MultiPartStreamer toDataStream(Deployment deployment) {
        MultiPartStreamer streamer = new MultiPartStreamer();
        streamer.addJson("deployOptions", ControllerHttpClient.metaToJson(deployment));
        streamer.addFile("applicationZip", deployment.applicationZip());
        return streamer;
    }

    private static String asString(HttpResponse<byte[]> response) {
        return new String(ControllerHttpClient.asBytes(response), StandardCharsets.UTF_8);
    }

    private static byte[] asBytes(HttpResponse<byte[]> response) {
        ControllerHttpClient.toInspector(response);
        return response.body();
    }

    private static Inspector toInspector(HttpResponse<byte[]> response) {
        Cursor rootObject = ControllerHttpClient.toSlime(response.body()).get();
        if (response.statusCode() / 100 != 2) {
            throw new RuntimeException(response.request() + " returned code " + response.statusCode() + " (" + rootObject.field("error-code").asString() + "): " + rootObject.field("message").asString());
        }
        return rootObject;
    }

    private static String toMessage(HttpResponse<byte[]> response) {
        return ControllerHttpClient.toInspector(response).field("message").asString();
    }

    private static DeploymentResult toDeploymentResult(HttpResponse<byte[]> response) {
        Inspector rootObject = ControllerHttpClient.toInspector(response);
        return new DeploymentResult(rootObject.field("message").asString(), rootObject.field("run").asLong());
    }

    private static DeploymentLog toDeploymentLog(HttpResponse<byte[]> response) {
        Inspector rootObject = ControllerHttpClient.toInspector(response);
        ArrayList<DeploymentLog.Entry> entries = new ArrayList<DeploymentLog.Entry>();
        rootObject.field("log").traverse((__, entryArray) -> entryArray.traverse((___, entryObject) -> entries.add(new DeploymentLog.Entry(Instant.ofEpochMilli(entryObject.field("at").asLong()), entryObject.field("type").asString(), entryObject.field("message").asString()))));
        return new DeploymentLog(entries, rootObject.field("active").asBool(), rootObject.field("lastId").valid() ? OptionalLong.of(rootObject.field("lastId").asLong()) : OptionalLong.empty());
    }

    private static Slime toSlime(byte[] data) {
        return new JsonDecoder().decode(new Slime(), data);
    }

    private static String toJson(Slime slime) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            new JsonFormat(true).encode((OutputStream)buffer, slime);
            return buffer.toString(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class MutualTlsControllerHttpClient
    extends ControllerHttpClient {
        private MutualTlsControllerHttpClient(URI endpoint, Path privateKeyFile, Path certificateFile) {
            super(endpoint, HttpClient.newBuilder().sslContext(new SslContextBuilder().withKeyStore(privateKeyFile, certificateFile).build()));
        }

        private MutualTlsControllerHttpClient(URI endpoint, String privateKey, String certificate) {
            super(endpoint, HttpClient.newBuilder().sslContext(new SslContextBuilder().withKeyStore(KeyUtils.fromPemEncodedPrivateKey((String)privateKey), X509CertificateUtils.certificateListFromPem((String)certificate)).build()));
        }
    }

    private static class SigningControllerHttpClient
    extends ControllerHttpClient {
        private final RequestSigner signer;

        private SigningControllerHttpClient(URI endpoint, String privateKey, ApplicationId id) {
            super(endpoint, HttpClient.newBuilder());
            this.signer = new RequestSigner(privateKey, id.serializedForm());
        }

        private SigningControllerHttpClient(URI endpoint, Path privateKeyFile, ApplicationId id) {
            this(endpoint, ControllerHttpClient.unchecked(() -> Files.readString(privateKeyFile, StandardCharsets.UTF_8)), id);
        }

        @Override
        protected HttpRequest request(HttpRequest.Builder request, Method method, Supplier<InputStream> data) {
            return this.signer.signed(request, method, data);
        }
    }
}

