/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.api;

import ai.vespa.hosted.api.Method;
import ai.vespa.hosted.api.MultiPartStreamer;
import ai.vespa.hosted.api.Signatures;
import com.yahoo.security.KeyUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.time.Clock;
import java.util.Base64;
import java.util.function.Supplier;

public class RequestSigner {
    private final Signature signer;
    private final String keyId;
    private final Clock clock;

    public RequestSigner(String pemPrivateKey, String keyId) {
        this(pemPrivateKey, keyId, Clock.systemUTC());
    }

    RequestSigner(String pemPrivateKey, String keyId, Clock clock) {
        this.signer = KeyUtils.createSigner((PrivateKey)KeyUtils.fromPemEncodedPrivateKey((String)pemPrivateKey));
        this.keyId = keyId;
        this.clock = clock;
    }

    public HttpRequest signed(HttpRequest.Builder request, Method method, Supplier<InputStream> data) {
        try {
            String timestamp = this.clock.instant().toString();
            String contentHash = Base64.getEncoder().encodeToString(Signatures.sha256Digest(data::get));
            byte[] canonicalMessage = Signatures.canonicalMessageOf(method.name(), request.copy().build().uri(), timestamp, contentHash);
            this.signer.update(canonicalMessage);
            String signature = Base64.getEncoder().encodeToString(this.signer.sign());
            request.setHeader("X-Timestamp", timestamp);
            request.setHeader("X-Content-Hash", contentHash);
            request.setHeader("X-Key-Id", this.keyId);
            request.setHeader("X-Authorization", signature);
            request.method(method.name(), HttpRequest.BodyPublishers.ofInputStream(data));
            return request.build();
        }
        catch (SignatureException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public HttpRequest signed(HttpRequest.Builder request, Method method, MultiPartStreamer streamer) {
        request.setHeader("Content-Type", streamer.contentType());
        return this.signed(request, method, streamer::data);
    }

    public HttpRequest signed(HttpRequest.Builder request, Method method, byte[] data) {
        return this.signed(request, method, () -> new ByteArrayInputStream(data));
    }

    public HttpRequest signed(HttpRequest.Builder request, Method method) {
        return this.signed(request, method, InputStream::nullInputStream);
    }
}

