/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.api.annotations.Beta;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.TestAndSetCondition;
import com.yahoo.documentapi.messagebus.protocol.DocumentReply;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentReply;
import com.yahoo.documentapi.messagebus.protocol.TestAndSetMessage;
import java.util.Arrays;

public class RemoveDocumentMessage
extends TestAndSetMessage {
    private DocumentRemove remove = null;
    private long persistedTimestamp = 0L;

    RemoveDocumentMessage() {
    }

    public RemoveDocumentMessage(DocumentId documentId) {
        this.remove = new DocumentRemove(documentId);
    }

    public RemoveDocumentMessage(DocumentRemove remove) {
        this.remove = remove;
    }

    public DocumentId getDocumentId() {
        return this.remove.getId();
    }

    public void setDocumentId(DocumentId documentId) {
        if (documentId == null) {
            throw new IllegalArgumentException("Document id can not be null.");
        }
        this.remove = new DocumentRemove(documentId);
    }

    @Beta
    public void setPersistedTimestamp(long time) {
        this.persistedTimestamp = time;
    }

    @Beta
    public long getPersistedTimestamp() {
        return this.persistedTimestamp;
    }

    @Override
    public DocumentReply createReply() {
        return new RemoveDocumentReply();
    }

    @Override
    public int getApproxSize() {
        return super.getApproxSize() + 4 + this.remove.getId().toString().length();
    }

    public boolean hasSequenceId() {
        return true;
    }

    public long getSequenceId() {
        return Arrays.hashCode(this.remove.getId().getGlobalId());
    }

    public int getType() {
        return 100005;
    }

    @Override
    public void setCondition(TestAndSetCondition condition) {
        this.remove.setCondition(condition);
    }

    @Override
    public TestAndSetCondition getCondition() {
        return this.remove.getCondition();
    }

    public DocumentRemove getDocumentRemove() {
        return this.remove;
    }
}

