/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.documentapi.messagebus.protocol.ANDPolicy;
import com.yahoo.documentapi.messagebus.protocol.ContentPolicy;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocolPoliciesConfig;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocolRoutingPolicy;
import com.yahoo.documentapi.messagebus.protocol.DocumentRouteSelectorPolicy;
import com.yahoo.documentapi.messagebus.protocol.ErrorPolicy;
import com.yahoo.documentapi.messagebus.protocol.ExternPolicy;
import com.yahoo.documentapi.messagebus.protocol.LoadBalancerPolicy;
import com.yahoo.documentapi.messagebus.protocol.LocalServicePolicy;
import com.yahoo.documentapi.messagebus.protocol.MessageTypePolicy;
import com.yahoo.documentapi.messagebus.protocol.RoundRobinPolicy;
import com.yahoo.documentapi.messagebus.protocol.RoutingPolicyFactory;
import com.yahoo.documentapi.messagebus.protocol.SubsetServicePolicy;
import com.yahoo.vespa.config.content.DistributionConfig;

class RoutingPolicyFactories {
    private RoutingPolicyFactories() {
    }

    static class SubsetServicePolicyFactory
    implements RoutingPolicyFactory {
        SubsetServicePolicyFactory() {
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            return new SubsetServicePolicy(param);
        }
    }

    static class LoadBalancerPolicyFactory
    implements RoutingPolicyFactory {
        LoadBalancerPolicyFactory() {
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            return new LoadBalancerPolicy(param);
        }
    }

    static class RoundRobinPolicyFactory
    implements RoutingPolicyFactory {
        RoundRobinPolicyFactory() {
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            return new RoundRobinPolicy();
        }
    }

    static class LocalServicePolicyFactory
    implements RoutingPolicyFactory {
        LocalServicePolicyFactory() {
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            return new LocalServicePolicy(param);
        }
    }

    static class ExternPolicyFactory
    implements RoutingPolicyFactory {
        ExternPolicyFactory() {
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            ExternPolicy ret = new ExternPolicy(param);
            String error = ret.getError();
            if (error != null) {
                return new ErrorPolicy(error);
            }
            return ret;
        }
    }

    static class DocumentRouteSelectorPolicyFactory
    implements RoutingPolicyFactory {
        private final String configId;
        private final DocumentProtocolPoliciesConfig config;

        public DocumentRouteSelectorPolicyFactory(String configId, DocumentProtocolPoliciesConfig config) {
            this.configId = configId;
            this.config = config;
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            if (this.config != null) {
                try {
                    return new DocumentRouteSelectorPolicy(this.config);
                }
                catch (IllegalArgumentException e) {
                    return new ErrorPolicy(e.getMessage());
                }
            }
            DocumentRouteSelectorPolicy ret = new DocumentRouteSelectorPolicy(param == null || param.isEmpty() ? this.configId : param);
            String error = ret.getError();
            if (error != null) {
                return new ErrorPolicy(error);
            }
            return ret;
        }
    }

    static class MessageTypePolicyFactory
    implements RoutingPolicyFactory {
        private final String configId;
        private final DocumentProtocolPoliciesConfig config;

        public MessageTypePolicyFactory(String configId, DocumentProtocolPoliciesConfig config) {
            this.configId = configId;
            this.config = config;
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            if (this.config != null) {
                if (this.config.cluster(param) == null) {
                    return new ErrorPolicy("No message type config for cluster '" + param + "'");
                }
                return new MessageTypePolicy(this.config.cluster(param));
            }
            return new MessageTypePolicy(param == null || param.isEmpty() ? this.configId : param);
        }
    }

    static class ContentPolicyFactory
    implements RoutingPolicyFactory {
        private final DistributionConfig distributionConfig;

        public ContentPolicyFactory(DistributionConfig config) {
            this.distributionConfig = config;
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            return new ContentPolicy(param, this.distributionConfig);
        }
    }

    static class AndPolicyFactory
    implements RoutingPolicyFactory {
        AndPolicyFactory() {
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            return new ANDPolicy(param);
        }
    }
}

