/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi;

import com.yahoo.document.Document;
import com.yahoo.documentapi.Response;
import com.yahoo.messagebus.Trace;

public class DocumentResponse
extends Response {
    private final Document document;

    public DocumentResponse(long requestId) {
        this(requestId, (Document)null);
    }

    public DocumentResponse(long requestId, Document document) {
        this(requestId, document, null);
    }

    public DocumentResponse(long requestId, Document document, Trace trace) {
        this(requestId, document, null, document != null ? Response.Outcome.SUCCESS : Response.Outcome.NOT_FOUND, trace);
    }

    public DocumentResponse(long requestId, Document document, String textMessage, Response.Outcome outcome) {
        this(requestId, document, textMessage, outcome, null);
    }

    public DocumentResponse(long requestId, Document document, String textMessage, Response.Outcome outcome, Trace trace) {
        super(requestId, textMessage, outcome, trace);
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public boolean isSuccess() {
        return super.isSuccess() || this.outcome() == Response.Outcome.NOT_FOUND;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.document == null ? 0 : this.document.hashCode());
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DocumentResponse)) {
            return false;
        }
        DocumentResponse docResp = (DocumentResponse)o;
        return super.equals(docResp) && (this.document == null && docResp.document == null || this.document != null && docResp.document != null && this.document.equals((Object)docResp.document));
    }

    @Override
    public String toString() {
        return "Document" + super.toString() + (String)(this.document == null ? "" : " " + this.document);
    }
}

