/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.collections.Tuple2;
import com.yahoo.component.Version;
import com.yahoo.component.VersionSpecification;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentTypeManagerConfigurer;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocolPoliciesConfig;
import com.yahoo.documentapi.messagebus.protocol.ReplyMerger;
import com.yahoo.documentapi.messagebus.protocol.RoutableFactories60;
import com.yahoo.documentapi.messagebus.protocol.RoutableFactories80;
import com.yahoo.documentapi.messagebus.protocol.RoutableFactory;
import com.yahoo.documentapi.messagebus.protocol.RoutableRepository;
import com.yahoo.documentapi.messagebus.protocol.RoutingPolicyFactories;
import com.yahoo.documentapi.messagebus.protocol.RoutingPolicyFactory;
import com.yahoo.documentapi.messagebus.protocol.RoutingPolicyRepository;
import com.yahoo.messagebus.ErrorCode;
import com.yahoo.messagebus.Protocol;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.Routable;
import com.yahoo.messagebus.routing.RoutingContext;
import com.yahoo.messagebus.routing.RoutingNodeIterator;
import com.yahoo.messagebus.routing.RoutingPolicy;
import com.yahoo.text.Utf8String;
import com.yahoo.vespa.config.content.DistributionConfig;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DocumentProtocol
implements Protocol {
    private static final Logger log = Logger.getLogger(DocumentProtocol.class.getName());
    private final RoutingPolicyRepository routingPolicyRepository = new RoutingPolicyRepository();
    private final RoutableRepository routableRepository;
    private final DocumentTypeManager docMan;
    public static final Utf8String NAME = new Utf8String("document");
    public static final int DOCUMENT_MESSAGE = 100000;
    public static final int MESSAGE_GETDOCUMENT = 100003;
    public static final int MESSAGE_PUTDOCUMENT = 100004;
    public static final int MESSAGE_REMOVEDOCUMENT = 100005;
    public static final int MESSAGE_UPDATEDOCUMENT = 100006;
    public static final int MESSAGE_CREATEVISITOR = 100007;
    public static final int MESSAGE_DESTROYVISITOR = 100008;
    public static final int MESSAGE_VISITORINFO = 100009;
    public static final int MESSAGE_MAPVISITOR = 100015;
    public static final int MESSAGE_GETBUCKETSTATE = 100018;
    public static final int MESSAGE_STATBUCKET = 100019;
    public static final int MESSAGE_GETBUCKETLIST = 100020;
    public static final int MESSAGE_DOCUMENTLIST = 100021;
    public static final int MESSAGE_EMPTYBUCKETS = 100023;
    public static final int MESSAGE_REMOVELOCATION = 100024;
    public static final int MESSAGE_QUERYRESULT = 100025;
    public static final int DOCUMENT_REPLY = 200000;
    public static final int REPLY_GETDOCUMENT = 200003;
    public static final int REPLY_PUTDOCUMENT = 200004;
    public static final int REPLY_REMOVEDOCUMENT = 200005;
    public static final int REPLY_UPDATEDOCUMENT = 200006;
    public static final int REPLY_CREATEVISITOR = 200007;
    public static final int REPLY_DESTROYVISITOR = 200008;
    public static final int REPLY_VISITORINFO = 200009;
    public static final int REPLY_MAPVISITOR = 200015;
    public static final int REPLY_GETBUCKETSTATE = 200018;
    public static final int REPLY_STATBUCKET = 200019;
    public static final int REPLY_GETBUCKETLIST = 200020;
    public static final int REPLY_DOCUMENTLIST = 200021;
    public static final int REPLY_EMPTYBUCKETS = 200023;
    public static final int REPLY_REMOVELOCATION = 200024;
    public static final int REPLY_QUERYRESULT = 200025;
    public static final int REPLY_WRONGDISTRIBUTION = 201000;
    public static final int REPLY_DOCUMENTIGNORED = 201001;
    public static final int ERROR_MESSAGE_IGNORED = 250001;
    public static final int ERROR_POLICY_FAILURE = 250002;
    public static final int ERROR_DOCUMENT_NOT_FOUND = 251001;
    public static final int ERROR_DOCUMENT_EXISTS = 251002;
    public static final int ERROR_NOT_IMPLEMENTED = 251004;
    public static final int ERROR_ILLEGAL_PARAMETERS = 251005;
    public static final int ERROR_UNKNOWN_COMMAND = 251007;
    public static final int ERROR_UNPARSEABLE = 251008;
    public static final int ERROR_NO_SPACE = 251009;
    public static final int ERROR_IGNORED = 251010;
    public static final int ERROR_INTERNAL_FAILURE = 251011;
    public static final int ERROR_REJECTED = 251012;
    public static final int ERROR_TEST_AND_SET_CONDITION_FAILED = 251013;
    public static final int ERROR_PROCESSING_FAILURE = 252001;
    public static final int ERROR_TIMESTAMP_EXIST = 252002;
    public static final int ERROR_NODE_NOT_READY = 151001;
    public static final int ERROR_WRONG_DISTRIBUTION = 151002;
    public static final int ERROR_ABORTED = 151004;
    public static final int ERROR_BUSY = 151005;
    public static final int ERROR_NOT_CONNECTED = 151006;
    public static final int ERROR_DISK_FAILURE = 151007;
    public static final int ERROR_IO_FAILURE = 151008;
    public static final int ERROR_BUCKET_NOT_FOUND = 151009;
    public static final int ERROR_BUCKET_DELETED = 151012;
    public static final int ERROR_STALE_TIMESTAMP = 151013;
    public static final int ERROR_SUSPENDED = 152001;

    public static Priority getPriority(int val) {
        for (Priority pri : Priority.values()) {
            if (val != pri.val) continue;
            return pri;
        }
        throw new IllegalArgumentException("Unknown priority: " + val);
    }

    public static Priority getPriorityByName(String name) {
        return Priority.valueOf(name);
    }

    public DocumentProtocol(DocumentTypeManager docMan) {
        this(docMan, null);
    }

    public DocumentProtocol(DocumentTypeManager documentTypeManager, DocumentProtocolPoliciesConfig policiesConfig, DistributionConfig distributionConfig) {
        this(Objects.requireNonNull(documentTypeManager), null, Objects.requireNonNull(policiesConfig), Objects.requireNonNull(distributionConfig));
    }

    public DocumentProtocol(DocumentTypeManager docMan, String configId) {
        this(docMan, configId == null ? "client" : configId, null, null);
    }

    private DocumentProtocol(DocumentTypeManager docMan, String configId, DocumentProtocolPoliciesConfig policiesConfig, DistributionConfig distributionConfig) {
        if (docMan != null) {
            this.docMan = docMan;
        } else {
            this.docMan = new DocumentTypeManager();
            DocumentTypeManagerConfigurer.configure((DocumentTypeManager)this.docMan, (String)configId);
        }
        this.routableRepository = new RoutableRepository();
        this.putRoutingPolicyFactory("AND", new RoutingPolicyFactories.AndPolicyFactory());
        this.putRoutingPolicyFactory("Content", new RoutingPolicyFactories.ContentPolicyFactory(distributionConfig));
        this.putRoutingPolicyFactory("DocumentRouteSelector", new RoutingPolicyFactories.DocumentRouteSelectorPolicyFactory(configId, policiesConfig));
        this.putRoutingPolicyFactory("Extern", new RoutingPolicyFactories.ExternPolicyFactory());
        this.putRoutingPolicyFactory("LocalService", new RoutingPolicyFactories.LocalServicePolicyFactory());
        this.putRoutingPolicyFactory("MessageType", new RoutingPolicyFactories.MessageTypePolicyFactory(configId, policiesConfig));
        this.putRoutingPolicyFactory("RoundRobin", new RoutingPolicyFactories.RoundRobinPolicyFactory());
        this.putRoutingPolicyFactory("LoadBalancer", new RoutingPolicyFactories.LoadBalancerPolicyFactory());
        this.putRoutingPolicyFactory("SubsetService", new RoutingPolicyFactories.SubsetServicePolicyFactory());
        this.registerLegacyV6Factories();
        this.registerV8Factories();
    }

    private void registerLegacyV6Factories() {
        VersionSpecification version6 = new VersionSpecification(Integer.valueOf(6), Integer.valueOf(221));
        List<VersionSpecification> from6 = List.of(version6);
        this.putRoutableFactory(100007, (RoutableFactory)new RoutableFactories60.CreateVisitorMessageFactory(), from6);
        this.putRoutableFactory(100008, (RoutableFactory)new RoutableFactories60.DestroyVisitorMessageFactory(), from6);
        this.putRoutableFactory(100021, (RoutableFactory)new RoutableFactories60.DocumentListMessageFactory(), from6);
        this.putRoutableFactory(100023, (RoutableFactory)new RoutableFactories60.EmptyBucketsMessageFactory(), from6);
        this.putRoutableFactory(100020, (RoutableFactory)new RoutableFactories60.GetBucketListMessageFactory(), from6);
        this.putRoutableFactory(100018, (RoutableFactory)new RoutableFactories60.GetBucketStateMessageFactory(), from6);
        this.putRoutableFactory(100003, (RoutableFactory)new RoutableFactories60.GetDocumentMessageFactory(), from6);
        this.putRoutableFactory(100015, (RoutableFactory)new RoutableFactories60.MapVisitorMessageFactory(), from6);
        this.putRoutableFactory(100004, (RoutableFactory)new RoutableFactories60.PutDocumentMessageFactory(), from6);
        this.putRoutableFactory(100025, (RoutableFactory)new RoutableFactories60.QueryResultMessageFactory(), from6);
        this.putRoutableFactory(100005, (RoutableFactory)new RoutableFactories60.RemoveDocumentMessageFactory(), from6);
        this.putRoutableFactory(100024, (RoutableFactory)new RoutableFactories60.RemoveLocationMessageFactory(), from6);
        this.putRoutableFactory(100019, (RoutableFactory)new RoutableFactories60.StatBucketMessageFactory(), from6);
        this.putRoutableFactory(100006, (RoutableFactory)new RoutableFactories60.UpdateDocumentMessageFactory(), from6);
        this.putRoutableFactory(100009, (RoutableFactory)new RoutableFactories60.VisitorInfoMessageFactory(), from6);
        this.putRoutableFactory(200007, (RoutableFactory)new RoutableFactories60.CreateVisitorReplyFactory(), from6);
        this.putRoutableFactory(200008, (RoutableFactory)new RoutableFactories60.DestroyVisitorReplyFactory(), from6);
        this.putRoutableFactory(201001, (RoutableFactory)new RoutableFactories60.DocumentIgnoredReplyFactory(), from6);
        this.putRoutableFactory(200021, (RoutableFactory)new RoutableFactories60.DocumentListReplyFactory(), from6);
        this.putRoutableFactory(200023, (RoutableFactory)new RoutableFactories60.EmptyBucketsReplyFactory(), from6);
        this.putRoutableFactory(200020, (RoutableFactory)new RoutableFactories60.GetBucketListReplyFactory(), from6);
        this.putRoutableFactory(200018, (RoutableFactory)new RoutableFactories60.GetBucketStateReplyFactory(), from6);
        this.putRoutableFactory(200003, (RoutableFactory)new RoutableFactories60.GetDocumentReplyFactory(), from6);
        this.putRoutableFactory(200015, (RoutableFactory)new RoutableFactories60.MapVisitorReplyFactory(), from6);
        this.putRoutableFactory(200004, (RoutableFactory)new RoutableFactories60.PutDocumentReplyFactory(), from6);
        this.putRoutableFactory(200025, (RoutableFactory)new RoutableFactories60.QueryResultReplyFactory(), from6);
        this.putRoutableFactory(200005, (RoutableFactory)new RoutableFactories60.RemoveDocumentReplyFactory(), from6);
        this.putRoutableFactory(200024, (RoutableFactory)new RoutableFactories60.RemoveLocationReplyFactory(), from6);
        this.putRoutableFactory(200019, (RoutableFactory)new RoutableFactories60.StatBucketReplyFactory(), from6);
        this.putRoutableFactory(200006, (RoutableFactory)new RoutableFactories60.UpdateDocumentReplyFactory(), from6);
        this.putRoutableFactory(200009, (RoutableFactory)new RoutableFactories60.VisitorInfoReplyFactory(), from6);
        this.putRoutableFactory(201000, (RoutableFactory)new RoutableFactories60.WrongDistributionReplyFactory(), from6);
    }

    private void registerV8Factories() {
        VersionSpecification version8 = new VersionSpecification(Integer.valueOf(8), Integer.valueOf(310));
        List<VersionSpecification> from8 = List.of(version8);
        this.putRoutableFactory(100007, RoutableFactories80.createCreateVisitorMessageFactory(), from8);
        this.putRoutableFactory(100008, RoutableFactories80.createDestroyVisitorMessageFactory(), from8);
        this.putRoutableFactory(100021, RoutableFactories80.createDocumentListMessageFactory(), from8);
        this.putRoutableFactory(100023, RoutableFactories80.createEmptyBucketsMessageFactory(), from8);
        this.putRoutableFactory(100020, RoutableFactories80.createGetBucketListMessageFactory(), from8);
        this.putRoutableFactory(100018, RoutableFactories80.createGetBucketStateMessageFactory(), from8);
        this.putRoutableFactory(100003, RoutableFactories80.createGetDocumentMessageFactory(), from8);
        this.putRoutableFactory(100015, RoutableFactories80.createMapVisitorMessageFactory(), from8);
        this.putRoutableFactory(100004, RoutableFactories80.createPutDocumentMessageFactory(), from8);
        this.putRoutableFactory(100025, RoutableFactories80.createQueryResultMessageFactory(), from8);
        this.putRoutableFactory(100005, RoutableFactories80.createRemoveDocumentMessageFactory(), from8);
        this.putRoutableFactory(100024, RoutableFactories80.createRemoveLocationMessageFactory(), from8);
        this.putRoutableFactory(100019, RoutableFactories80.createStatBucketMessageFactory(), from8);
        this.putRoutableFactory(100006, RoutableFactories80.createUpdateDocumentMessageFactory(), from8);
        this.putRoutableFactory(100009, RoutableFactories80.createVisitorInfoMessageFactory(), from8);
        this.putRoutableFactory(200007, RoutableFactories80.createCreateVisitorReplyFactory(), from8);
        this.putRoutableFactory(200008, RoutableFactories80.createDestroyVisitorReplyFactory(), from8);
        this.putRoutableFactory(201001, RoutableFactories80.createDocumentIgnoredReplyFactory(), from8);
        this.putRoutableFactory(200021, RoutableFactories80.createDocumentListReplyFactory(), from8);
        this.putRoutableFactory(200023, RoutableFactories80.createEmptyBucketsReplyFactory(), from8);
        this.putRoutableFactory(200020, RoutableFactories80.createGetBucketListReplyFactory(), from8);
        this.putRoutableFactory(200018, RoutableFactories80.createGetBucketStateReplyFactory(), from8);
        this.putRoutableFactory(200003, RoutableFactories80.createGetDocumentReplyFactory(), from8);
        this.putRoutableFactory(200015, RoutableFactories80.createMapVisitorReplyFactory(), from8);
        this.putRoutableFactory(200004, RoutableFactories80.createPutDocumentReplyFactory(), from8);
        this.putRoutableFactory(200025, RoutableFactories80.createQueryResultReplyFactory(), from8);
        this.putRoutableFactory(200005, RoutableFactories80.createRemoveDocumentReplyFactory(), from8);
        this.putRoutableFactory(200024, RoutableFactories80.createRemoveLocationReplyFactory(), from8);
        this.putRoutableFactory(200019, RoutableFactories80.createStatBucketReplyFactory(), from8);
        this.putRoutableFactory(200006, RoutableFactories80.createUpdateDocumentReplyFactory(), from8);
        this.putRoutableFactory(200009, RoutableFactories80.createVisitorInfoReplyFactory(), from8);
        this.putRoutableFactory(201000, RoutableFactories80.createWrongDistributionReplyFactory(), from8);
    }

    public DocumentProtocol putRoutingPolicyFactory(String name, RoutingPolicyFactory factory) {
        this.routingPolicyRepository.putFactory(name, factory);
        return this;
    }

    public DocumentProtocol putRoutableFactory(int type, RoutableFactory factory, VersionSpecification version) {
        this.routableRepository.putFactory(version, type, factory);
        return this;
    }

    public DocumentProtocol putRoutableFactory(int type, RoutableFactory factory, List<VersionSpecification> versions) {
        for (VersionSpecification version : versions) {
            this.putRoutableFactory(type, factory, version);
        }
        return this;
    }

    public static String getErrorName(int code) {
        switch (code) {
            case 250001: {
                return "MESSAGE_IGNORED";
            }
            case 250002: {
                return "POLICY_FAILURE";
            }
            case 251001: {
                return "DOCUMENT_NOT_FOUND";
            }
            case 251002: {
                return "DOCUMENT_EXISTS";
            }
            case 151009: {
                return "BUCKET_NOT_FOUND";
            }
            case 151012: {
                return "BUCKET_DELETED";
            }
            case 251004: {
                return "NOT_IMPLEMENTED";
            }
            case 251005: {
                return "ILLEGAL_PARAMETERS";
            }
            case 251010: {
                return "IGNORED";
            }
            case 251007: {
                return "UNKNOWN_COMMAND";
            }
            case 251008: {
                return "UNPARSEABLE";
            }
            case 251009: {
                return "NO_SPACE";
            }
            case 251011: {
                return "INTERNAL_FAILURE";
            }
            case 252001: {
                return "PROCESSING_FAILURE";
            }
            case 252002: {
                return "TIMESTAMP_EXIST";
            }
            case 151013: {
                return "STALE_TIMESTAMP";
            }
            case 151001: {
                return "NODE_NOT_READY";
            }
            case 151002: {
                return "WRONG_DISTRIBUTION";
            }
            case 251012: {
                return "REJECTED";
            }
            case 151004: {
                return "ABORTED";
            }
            case 151005: {
                return "BUSY";
            }
            case 151006: {
                return "NOT_CONNECTED";
            }
            case 151007: {
                return "DISK_FAILURE";
            }
            case 151008: {
                return "IO_FAILURE";
            }
            case 152001: {
                return "SUSPENDED";
            }
            case 251013: {
                return "TEST_AND_SET_CONDITION_FAILED";
            }
        }
        return ErrorCode.getName((int)code);
    }

    public static void merge(RoutingContext ctx) {
        DocumentProtocol.merge(ctx, new HashSet<Integer>(0));
    }

    public static void merge(RoutingContext ctx, Set<Integer> mask) {
        LinkedList<Reply> replies = new LinkedList<Reply>();
        RoutingNodeIterator it = ctx.getChildIterator();
        while (it.isValid()) {
            Reply ref = it.getReplyRef();
            replies.add(ref);
            it.next();
        }
        Tuple2<Integer, Reply> tuple = DocumentProtocol.merge(replies, mask);
        if (tuple.first != null) {
            ctx.getChildIterator().skip(((Integer)tuple.first).intValue()).removeReply();
        }
        ctx.setReply((Reply)tuple.second);
    }

    private static Tuple2<Integer, Reply> merge(List<Reply> replies, Set<Integer> mask) {
        ReplyMerger rm = new ReplyMerger();
        for (int i = 0; i < replies.size(); ++i) {
            if (mask.contains(i)) continue;
            rm.merge(i, replies.get(i));
        }
        return rm.mergedReply();
    }

    public static Reply merge(List<Reply> replies) {
        return (Reply)DocumentProtocol.merge(replies, new HashSet<Integer>((int)0)).second;
    }

    public static boolean hasOnlyErrorsOfType(Reply reply, int errCode) {
        if (!reply.hasErrors()) {
            return false;
        }
        for (int i = 0; i < reply.getNumErrors(); ++i) {
            if (reply.getError(i).getCode() == errCode) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NAME.toString();
    }

    public RoutingPolicy createPolicy(String name, String param) {
        return this.routingPolicyRepository.createPolicy(name, param);
    }

    public byte[] encode(Version version, Routable routable) {
        return this.routableRepository.encode(version, routable);
    }

    public Routable decode(Version version, byte[] data) {
        try {
            return this.routableRepository.decode(this.docMan, version, data);
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "Failed to decode document data", e);
            return null;
        }
    }

    public List<Integer> getRoutableTypes(Version version) {
        return this.routableRepository.getRoutableTypes(version);
    }

    public final DocumentTypeManager getDocumentTypeManager() {
        return this.docMan;
    }

    public static enum Priority {
        HIGHEST(0),
        VERY_HIGH(1),
        HIGH_1(2),
        HIGH_2(3),
        HIGH_3(4),
        NORMAL_1(5),
        NORMAL_2(6),
        NORMAL_3(7),
        NORMAL_4(8),
        NORMAL_5(9),
        NORMAL_6(10),
        LOW_1(11),
        LOW_2(12),
        LOW_3(13),
        VERY_LOW(14),
        LOWEST(15);

        private final int val;

        private Priority(int val) {
            this.val = val;
        }

        public int getValue() {
            return this.val;
        }
    }
}

