/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus;

import com.yahoo.concurrent.SystemTimer;
import com.yahoo.concurrent.Timer;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.RejectedExecutionException;

public class ScheduledEventQueue {
    private final Set<Entry> tasks = new TreeSet<Entry>();
    private long sequenceCounter = 0L;
    private Timer timer;
    private volatile boolean waiting = false;
    private volatile boolean shutdown = false;

    public ScheduledEventQueue() {
        this.timer = SystemTimer.INSTANCE;
    }

    public ScheduledEventQueue(Timer timer) {
        this.timer = timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushTask(Runnable task) {
        Set<Entry> set = this.tasks;
        synchronized (set) {
            if (this.shutdown) {
                throw new RejectedExecutionException("Tasks can't be scheduled since queue has been shut down.");
            }
            this.tasks.add(new Entry(task, 0L, this.sequenceCounter++));
            this.tasks.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushTask(Runnable task, long milliSecondsToWait) {
        Set<Entry> set = this.tasks;
        synchronized (set) {
            if (this.shutdown) {
                throw new RejectedExecutionException("Tasks can't be scheduled since queue has been shut down.");
            }
            this.tasks.add(new Entry(task, this.timer.milliTime() + milliSecondsToWait, this.sequenceCounter++));
            this.tasks.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWaiting() {
        Set<Entry> set = this.tasks;
        synchronized (set) {
            return this.waiting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Runnable getNextTask() {
        try {
            while (true) {
                Set<Entry> set = this.tasks;
                synchronized (set) {
                    Iterator<Entry> iter = this.tasks.iterator();
                    if (!iter.hasNext()) {
                        if (this.shutdown) {
                            return null;
                        }
                        this.waiting = true;
                        this.tasks.wait();
                        this.waiting = false;
                        continue;
                    }
                    Entry retEntry = iter.next();
                    long timeNow = this.timer.milliTime();
                    if (retEntry.getTimestamp() <= timeNow) {
                        iter.remove();
                        return retEntry.getTask();
                    }
                    this.waiting = true;
                    this.tasks.wait(retEntry.getTimestamp() - timeNow);
                    this.waiting = false;
                }
            }
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable popTask() {
        Set<Entry> set = this.tasks;
        synchronized (set) {
            Iterator<Entry> iter = this.tasks.iterator();
            if (!iter.hasNext()) {
                return null;
            }
            Entry retEntry = iter.next();
            if (retEntry.getTimestamp() > this.timer.milliTime()) {
                return null;
            }
            iter.remove();
            return retEntry.getTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeTasks() {
        Set<Entry> set = this.tasks;
        synchronized (set) {
            this.tasks.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Set<Entry> set = this.tasks;
        synchronized (set) {
            this.shutdown = true;
            this.tasks.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShutdown() {
        Set<Entry> set = this.tasks;
        synchronized (set) {
            return this.shutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size() {
        Set<Entry> set = this.tasks;
        synchronized (set) {
            return this.tasks.size();
        }
    }

    private static class Entry
    implements Comparable<Entry> {
        private Runnable task;
        private long timestamp;
        private long sequenceId;

        public Entry(Runnable task, long timestamp, long sequenceId) {
            this.task = task;
            this.timestamp = timestamp;
            this.sequenceId = sequenceId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.sequenceId != entry.sequenceId) {
                return false;
            }
            if (this.timestamp != entry.timestamp) {
                return false;
            }
            return this.task.equals(entry.task);
        }

        public int hashCode() {
            return Objects.hash(this.sequenceId, this.timestamp, this.task);
        }

        @Override
        public int compareTo(Entry o) {
            if (this.timestamp < o.timestamp) {
                return -1;
            }
            if (this.timestamp > o.timestamp) {
                return 1;
            }
            if (this.sequenceId < o.sequenceId) {
                return -1;
            }
            if (this.sequenceId > o.sequenceId) {
                return 1;
            }
            return 0;
        }

        public Runnable getTask() {
            return this.task;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getSequenceId() {
            return this.sequenceId;
        }
    }
}

