/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.systemstate.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Location {
    private List<String> items = new ArrayList<String>();

    public Location() {
    }

    public Location(String loc) {
        this.items.addAll(Arrays.asList(loc.split("/")));
        this.normalize();
    }

    public Location(List<String> items) {
        this.items.addAll(items);
        this.normalize();
    }

    public Location(Location loc) {
        this.items.addAll(loc.items);
    }

    public Location(Location pwd, List<String> items) {
        this.items.addAll(pwd.getItems());
        this.items.addAll(items);
        this.normalize();
    }

    public Location getNext() {
        ArrayList<String> next = new ArrayList<String>(this.items);
        next.remove(0);
        return new Location(next);
    }

    public List<String> getItems() {
        return this.items;
    }

    private Location normalize() {
        ArrayList<String> norm = new ArrayList<String>();
        for (String item : this.items) {
            if (item.equals("..")) {
                if (norm.size() == 0) continue;
                norm.remove(norm.size() - 1);
                continue;
            }
            if (item.equals(".")) continue;
            norm.add(item);
        }
        this.items = norm;
        return this;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < this.items.size(); ++i) {
            ret.append(this.items.get(i));
            if (i >= this.items.size() - 1) continue;
            ret.append("/");
        }
        return ret.toString();
    }
}

