/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocolRoutingPolicy;
import com.yahoo.jrt.slobrok.api.Mirror;
import com.yahoo.messagebus.EmptyReply;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.routing.Hop;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.routing.RoutingContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RoundRobinPolicy
implements DocumentProtocolRoutingPolicy {
    private final Map<String, CacheEntry> cache = new HashMap<String, CacheEntry>();

    public void select(RoutingContext ctx) {
        Hop hop = this.getRecipient(ctx);
        if (hop != null) {
            Route route = new Route(ctx.getRoute());
            route.setHop(0, hop);
            ctx.addChild(route);
        } else {
            EmptyReply reply = new EmptyReply();
            reply.addError(new Error(100002, "None of the configured recipients are currently available."));
            ctx.setReply((Reply)reply);
        }
    }

    public void merge(RoutingContext ctx) {
        DocumentProtocol.merge(ctx);
    }

    private synchronized Hop getRecipient(RoutingContext ctx) {
        CacheEntry entry = this.update(ctx);
        if (entry.recipients.isEmpty()) {
            return null;
        }
        if (++entry.offset >= entry.recipients.size()) {
            entry.offset = 0;
        }
        return new Hop(entry.recipients.get(entry.offset));
    }

    private CacheEntry update(RoutingContext ctx) {
        int upd;
        String key = this.getCacheKey(ctx);
        CacheEntry entry = this.cache.get(key);
        if (entry == null) {
            entry = new CacheEntry();
            this.cache.put(key, entry);
        }
        if (entry.generation != (upd = ctx.getMirror().updates())) {
            entry.generation = upd;
            entry.recipients.clear();
            for (int i = 0; i < ctx.getNumRecipients(); ++i) {
                List arr = ctx.getMirror().lookup(ctx.getRecipient(i).getHop(0).toString());
                for (Mirror.Entry item : arr) {
                    entry.recipients.add(Hop.parse((String)item.getName()));
                }
            }
        }
        return entry;
    }

    private String getCacheKey(RoutingContext ctx) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < ctx.getNumRecipients(); ++i) {
            ret.append(ctx.getRecipient(i).getHop(0).toString()).append(" ");
        }
        return ret.toString();
    }

    public void destroy() {
    }

    private class CacheEntry {
        private final List<Hop> recipients = new ArrayList<Hop>();
        private int generation = 0;
        private int offset = 0;

        private CacheEntry() {
        }
    }
}

