/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi;

import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentTypeManagerConfigurer;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.documentapi.AsyncParameters;
import com.yahoo.documentapi.AsyncSession;
import com.yahoo.documentapi.DocumentAccessParams;
import com.yahoo.documentapi.SubscriptionParameters;
import com.yahoo.documentapi.SubscriptionSession;
import com.yahoo.documentapi.SyncParameters;
import com.yahoo.documentapi.SyncSession;
import com.yahoo.documentapi.VisitorDestinationParameters;
import com.yahoo.documentapi.VisitorDestinationSession;
import com.yahoo.documentapi.VisitorParameters;
import com.yahoo.documentapi.VisitorSession;
import com.yahoo.documentapi.messagebus.MessageBusDocumentAccess;

public abstract class DocumentAccess {
    private final DocumentTypeManager documentTypeManager;
    private final ConfigSubscriber documentTypeConfigSubscriber;

    @Deprecated(since="7")
    public static DocumentAccess createDefault() {
        return new MessageBusDocumentAccess();
    }

    public static DocumentAccess createForNonContainer() {
        return new MessageBusDocumentAccess();
    }

    protected DocumentAccess(DocumentAccessParams params) {
        if (params.documentmanagerConfig().isPresent()) {
            this.documentTypeManager = new DocumentTypeManager(params.documentmanagerConfig().get());
            this.documentTypeConfigSubscriber = null;
        } else {
            this.documentTypeManager = new DocumentTypeManager();
            this.documentTypeConfigSubscriber = DocumentTypeManagerConfigurer.configure((DocumentTypeManager)this.documentTypeManager, (String)params.getDocumentManagerConfigId());
        }
    }

    public abstract SyncSession createSyncSession(SyncParameters var1);

    public abstract AsyncSession createAsyncSession(AsyncParameters var1);

    public abstract VisitorSession createVisitorSession(VisitorParameters var1) throws ParseException;

    public abstract VisitorDestinationSession createVisitorDestinationSession(VisitorDestinationParameters var1);

    public abstract SubscriptionSession createSubscription(SubscriptionParameters var1);

    public abstract SubscriptionSession openSubscription(SubscriptionParameters var1);

    public void shutdown() {
        if (this.documentTypeConfigSubscriber != null) {
            this.documentTypeConfigSubscriber.close();
        }
    }

    public DocumentTypeManager getDocumentTypeManager() {
        return this.documentTypeManager;
    }
}

