/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.documentapi.AsyncParameters;
import com.yahoo.documentapi.DocumentAccessException;
import com.yahoo.documentapi.DocumentOperationParameters;
import com.yahoo.documentapi.Response;
import com.yahoo.documentapi.Result;
import com.yahoo.documentapi.SyncParameters;
import com.yahoo.documentapi.SyncSession;
import com.yahoo.documentapi.messagebus.MessageBusAsyncSession;
import com.yahoo.documentapi.messagebus.MessageBusParams;
import com.yahoo.documentapi.messagebus.MessageBusSession;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.GetDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.GetDocumentReply;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentReply;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentReply;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageBus;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Routable;
import java.time.Duration;
import java.time.Instant;

public class MessageBusSyncSession
implements MessageBusSession,
SyncSession,
ReplyHandler {
    private final MessageBusAsyncSession session;
    private final Duration defaultTimeout;

    MessageBusSyncSession(SyncParameters syncParams, MessageBus bus, MessageBusParams mbusParams) {
        this.session = new MessageBusAsyncSession(new AsyncParameters(), bus, mbusParams, this);
        this.defaultTimeout = syncParams.defaultTimeout().orElse(null);
    }

    public void handleReply(Reply reply) {
        if (reply.getContext() instanceof RequestMonitor) {
            ((RequestMonitor)reply.getContext()).replied(reply);
        } else {
            ReplyHandler handler = reply.getCallStack().pop((Routable)reply);
            handler.handleReply(reply);
        }
    }

    @Override
    public Response getNext() {
        throw new UnsupportedOperationException("Queue not supported.");
    }

    @Override
    public Response getNext(int timeout) {
        throw new UnsupportedOperationException("Queue not supported.");
    }

    @Override
    public void destroy() {
        this.session.destroy();
    }

    public Reply syncSend(Message msg) {
        return this.syncSend(msg, DocumentOperationParameters.parameters());
    }

    private Reply syncSend(Message msg, DocumentOperationParameters parameters) {
        return this.syncSend(msg, this.defaultTimeout, parameters);
    }

    private Reply syncSend(Message msg, Duration timeout, DocumentOperationParameters parameters) {
        if (timeout != null) {
            parameters = parameters.withDeadline(Instant.now().plus(timeout));
        }
        try {
            RequestMonitor monitor = new RequestMonitor();
            msg.setContext((Object)monitor);
            msg.pushHandler((ReplyHandler)this);
            Result result = null;
            while (!(result != null && result.type() != Result.ResultType.TRANSIENT_ERROR || (result = this.session.send(msg, parameters)) != null && result.isSuccess())) {
                Thread.sleep(100L);
            }
            if (!result.isSuccess()) {
                throw new DocumentAccessException(result.getError().toString());
            }
            return monitor.waitForReply();
        }
        catch (InterruptedException e) {
            throw new DocumentAccessException(e);
        }
    }

    @Override
    public void put(DocumentPut documentPut) {
        this.put(documentPut, DocumentOperationParameters.parameters());
    }

    @Override
    public void put(DocumentPut documentPut, DocumentProtocol.Priority priority) {
        this.put(documentPut, DocumentOperationParameters.parameters().withPriority(priority));
    }

    @Override
    public void put(DocumentPut documentPut, DocumentOperationParameters parameters) {
        PutDocumentMessage msg = new PutDocumentMessage(documentPut);
        msg.setPriority(parameters.priority().orElse(DocumentProtocol.Priority.NORMAL_3));
        Reply reply = this.syncSend(msg, parameters);
        if (reply.hasErrors()) {
            throw new DocumentAccessException(MessageBusAsyncSession.getErrorMessage(reply), reply.getErrorCodes());
        }
    }

    @Override
    public Document get(DocumentId id, Duration timeout) {
        return this.get(id, DocumentOperationParameters.parameters(), timeout);
    }

    @Override
    public Document get(DocumentId id, String fieldSet, DocumentProtocol.Priority pri, Duration timeout) {
        return this.get(id, DocumentOperationParameters.parameters().withFieldSet(fieldSet).withPriority(pri), timeout);
    }

    @Override
    public Document get(DocumentId id, DocumentOperationParameters parameters, Duration timeout) {
        GetDocumentMessage msg = new GetDocumentMessage(id, parameters.fieldSet().orElse("[all]"));
        msg.setPriority(parameters.priority().orElse(DocumentProtocol.Priority.NORMAL_1));
        Reply reply = this.syncSend(msg, timeout != null ? timeout : this.defaultTimeout, parameters);
        if (reply.hasErrors()) {
            throw new DocumentAccessException(MessageBusAsyncSession.getErrorMessage(reply));
        }
        if (reply.getType() != 200003) {
            throw new DocumentAccessException("Received unknown response: " + reply);
        }
        GetDocumentReply docReply = (GetDocumentReply)reply;
        Document doc = docReply.getDocument();
        if (doc != null) {
            doc.setLastModified(Long.valueOf(docReply.getLastModified()));
        }
        return doc;
    }

    @Override
    public boolean remove(DocumentRemove documentRemove) {
        return this.remove(documentRemove, DocumentOperationParameters.parameters());
    }

    @Override
    public boolean remove(DocumentRemove documentRemove, DocumentProtocol.Priority pri) {
        return this.remove(documentRemove, DocumentOperationParameters.parameters().withPriority(pri));
    }

    @Override
    public boolean remove(DocumentRemove documentRemove, DocumentOperationParameters parameters) {
        RemoveDocumentMessage msg = new RemoveDocumentMessage(documentRemove.getId());
        msg.setPriority(parameters.priority().orElse(DocumentProtocol.Priority.NORMAL_2));
        msg.setCondition(documentRemove.getCondition());
        Reply reply = this.syncSend(msg, parameters);
        if (reply.hasErrors()) {
            throw new DocumentAccessException(MessageBusAsyncSession.getErrorMessage(reply));
        }
        if (reply.getType() != 200005) {
            throw new DocumentAccessException("Received unknown response: " + reply);
        }
        return ((RemoveDocumentReply)reply).wasFound();
    }

    @Override
    public boolean update(DocumentUpdate update) {
        return this.update(update, DocumentOperationParameters.parameters());
    }

    @Override
    public boolean update(DocumentUpdate update, DocumentProtocol.Priority pri) {
        return this.update(update, DocumentOperationParameters.parameters().withPriority(pri));
    }

    @Override
    public boolean update(DocumentUpdate update, DocumentOperationParameters parameters) {
        UpdateDocumentMessage msg = new UpdateDocumentMessage(update);
        msg.setPriority(parameters.priority().orElse(DocumentProtocol.Priority.NORMAL_2));
        Reply reply = this.syncSend(msg, parameters);
        if (reply.hasErrors()) {
            throw new DocumentAccessException(MessageBusAsyncSession.getErrorMessage(reply), reply.getErrorCodes());
        }
        if (reply.getType() != 200006) {
            throw new DocumentAccessException("Received unknown response: " + reply);
        }
        return ((UpdateDocumentReply)reply).wasFound();
    }

    @Override
    public String getRoute() {
        return this.session.getRoute();
    }

    @Override
    public void setRoute(String route) {
        this.session.setRoute(route);
    }

    @Override
    public int getTraceLevel() {
        return this.session.getTraceLevel();
    }

    @Override
    public void setTraceLevel(int traceLevel) {
        this.session.setTraceLevel(traceLevel);
    }

    static class RequestMonitor {
        private Reply reply = null;

        RequestMonitor() {
        }

        synchronized Reply waitForReply() throws InterruptedException {
            while (this.reply == null) {
                this.wait();
            }
            return this.reply;
        }

        synchronized void replied(Reply reply) {
            this.reply = reply;
            this.notify();
        }
    }
}

