/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.jrt.slobrok.api.Mirror;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class LoadBalancer {
    private List<NodeMetrics> nodeWeights = new CopyOnWriteArrayList<NodeMetrics>();
    private String cluster;
    private double position = 0.0;

    public LoadBalancer(String cluster) {
        this.cluster = cluster;
    }

    public List<NodeMetrics> getNodeWeights() {
        return this.nodeWeights;
    }

    public int getIndex(String nodeName) {
        try {
            String s = nodeName.substring(this.cluster.length() + 1);
            s = s.substring(0, s.indexOf("/"));
            s = s.substring(s.lastIndexOf(".") + 1);
            return Integer.parseInt(s);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            String err = "Expected recipient on the form '" + this.cluster + "/x/[y.]number/z', got '" + nodeName + "'.";
            throw new IllegalArgumentException(err, e);
        }
    }

    public Node getRecipient(List<Mirror.Entry> choices) {
        if (choices.isEmpty()) {
            return null;
        }
        double weightSum = 0.0;
        Node selectedNode = null;
        for (Mirror.Entry entry : choices) {
            NodeMetrics nodeMetrics = this.getNodeMetrics(entry);
            if (!((weightSum += nodeMetrics.weight) > this.position)) continue;
            selectedNode = new Node(entry, nodeMetrics);
            break;
        }
        if (selectedNode == null) {
            this.position -= weightSum;
            selectedNode = new Node(choices.get(0), this.getNodeMetrics(choices.get(0)));
        }
        this.position += 1.0;
        selectedNode.metrics.sent.incrementAndGet();
        return selectedNode;
    }

    private NodeMetrics getNodeMetrics(Mirror.Entry entry) {
        int index = this.getIndex(entry.getName());
        while (this.nodeWeights.size() < index + 1) {
            this.nodeWeights.add(null);
        }
        NodeMetrics nodeMetrics = this.nodeWeights.get(index);
        if (nodeMetrics == null) {
            nodeMetrics = new NodeMetrics();
            this.nodeWeights.set(index, nodeMetrics);
        }
        return nodeMetrics;
    }

    private void increaseWeights() {
        for (NodeMetrics n : this.nodeWeights) {
            if (n == null) continue;
            double want = n.weight * 1.0101010101010102;
            if (want >= 1.0) {
                n.weight = want;
                continue;
            }
            n.weight = 1.0;
        }
    }

    public void received(Node node, boolean busy) {
        if (busy) {
            double wantWeight = node.metrics.weight - 0.01;
            if (wantWeight < 1.0) {
                this.increaseWeights();
                node.metrics.weight = 1.0;
            } else {
                node.metrics.weight = wantWeight;
            }
            node.metrics.busy.incrementAndGet();
        }
    }

    public static class Node {
        public Mirror.Entry entry;
        public NodeMetrics metrics;

        public Node(Mirror.Entry e, NodeMetrics m) {
            this.entry = e;
            this.metrics = m;
        }
    }

    public static class NodeMetrics {
        public AtomicLong sent = new AtomicLong();
        public AtomicLong busy = new AtomicLong();
        public double weight = 1.0;
    }
}

