/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus;

import com.yahoo.documentapi.AckToken;
import com.yahoo.documentapi.VisitorDestinationParameters;
import com.yahoo.documentapi.VisitorDestinationSession;
import com.yahoo.documentapi.VisitorResponse;
import com.yahoo.documentapi.messagebus.protocol.DocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.DocumentReply;
import com.yahoo.messagebus.DestinationSession;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageBus;
import com.yahoo.messagebus.MessageHandler;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.Routable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageBusVisitorDestinationSession
implements VisitorDestinationSession,
MessageHandler {
    private static final Logger log = Logger.getLogger(MessageBusVisitorDestinationSession.class.getName());
    private DestinationSession session;
    private VisitorDestinationParameters params;

    public MessageBusVisitorDestinationSession(VisitorDestinationParameters params, MessageBus bus) {
        this.params = params;
        this.session = bus.createDestinationSession(params.getSessionName(), true, (MessageHandler)this);
        params.getDataHandler().setSession(this);
    }

    public void handleMessage(Message message) {
        DocumentReply reply = ((DocumentMessage)message).createReply();
        message.swapState((Routable)reply);
        this.params.getDataHandler().onMessage(message, new AckToken((Object)reply));
    }

    @Override
    public void ack(AckToken token) {
        try {
            log.log(Level.FINE, "Sending ack " + token.ackObject);
            this.session.reply((Reply)token.ackObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void destroy() {
        this.session.destroy();
        this.session = null;
    }

    @Override
    public void abort() {
        this.destroy();
    }

    @Override
    public VisitorResponse getNext() {
        return this.params.getDataHandler().getNext();
    }

    @Override
    public VisitorResponse getNext(int timeoutMilliseconds) throws InterruptedException {
        return this.params.getDataHandler().getNext(timeoutMilliseconds);
    }
}

